<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithTitle;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\DB;

class ExportBill implements FromView, ShouldAutoSize, WithTitle
{
    protected $tagihan;
    protected $status;
    protected $tgl_aktif_awal;
    protected $tgl_aktif_akhir;
    protected $institution;

    public function __construct(string $tagihan, string $status,string $tgl_aktif_awal,string $tgl_aktif_akhir, string $institution)
    {
        $this->tagihan = $tagihan;
        $this->status = $status;
        $this->tgl_aktif_awal = $tgl_aktif_awal;
        $this->tgl_aktif_akhir = $tgl_aktif_akhir;
        $this->institution = $institution;
    }

    public function title(): string
    {
        return 'Laporan Tagihan';
    }
    public function view(): View
    {
        
        
        $query = DB::table('bill_details as bd')
            ->leftJoin('bills as b', 'b.id', '=', 'bd.bill_id')
            ->leftJoin('bill_categories as bc', 'b.bill_category_id', '=', 'bc.id')
            ->leftJoin('payments as p', 'bd.id', '=', 'p.bill_detail_id')
            ->join('students as s', 's.id', '=', 'bd.student_id')
            ->leftJoin('school_years as sy', 'sy.id', '=', 'b.school_year_id')
            ->where('b.institution_id', (int) $this->institution)
            ->where('b.name', $this->tagihan);

        if ($this->status !== 'ALL') {
            $query->where('bd.status', $this->status);
        }
        
        if (!empty($this->tgl_aktif_awal) && !empty($this->tgl_aktif_akhir)) {
            $query->whereBetween('bd.actived_at', [$this->tgl_aktif_awal, $this->tgl_aktif_akhir]);
        }

        $data = $query
            ->groupBy('bd.id', 's.nis', 's.name', 'b.name', 'bd.amount', 'bd.updated_at', 'bd.actived_at', 'bd.status', 'bc.name')
            ->select('bd.id','bd.actived_at', 'bd.status', 's.name as nama_santri', 'b.name as deskripsi', 'bd.amount as nominal', 'bd.updated_at as tanggal', DB::raw('MONTH(bd.actived_at) as bulan_aktif'), DB::raw('YEAR(bd.actived_at) as tahun_aktif'), 'bc.name as kategori', 's.nis as nis_santri')
            ->get();

        $viewData = [
            'data' => $data,
        ];

        return view('pages.institution.report.finance.exportBill', $viewData);
    }
}
