<?php

namespace App\Exports;

use App\Models\Student;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class StudentExport implements FromView, ShouldAutoSize
{
    public function view(): View
    {
        $students = Student::with('school_class')->get();
        return view('pages.institution.manage-data.student.exports.santri-excel', compact('students'));
    }
}
