<?php

namespace App\Exports\StudentFormatSheet;

use App\Models\SchoolClass;
use App\Models\Student;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithTitle;

class ClassCodeSheet implements FromView, ShouldAutoSize, WithTitle
{
    public function view(): View
    {
        $schoolClasses = SchoolClass::latest()->whereHas('educational_level', function ($query) {
            $query->where('institution_id', institution()->id);
        })->get();
        return view('pages.institution.manage-data.student.exports.sheets.kode-kelas-format', compact('schoolClasses'));
    }

    public function title(): string
    {
        return 'Kode Kelas';
    }
}
