<?php

namespace App\Http\Controllers\Ajax;

use App\Http\Controllers\Controller;
use App\Models\BillDetail;
use GuzzleHttp\Client;
use Illuminate\Http\Request;

class BillAjaxController extends Controller
{
    public function show(Client $client, $id, $student_id, $status)
    {
        $response = client($client, route_api('api.bill.details', [$id, $student_id, $status], CUSTOM_BASE_URL_API));

        return $response;
    }

    public function fetchCicil(Request $request)
    {
        $response = [];
        $bill_detail = BillDetail::with('bill')
            ->where('student_id', $request->student_id)
            ->where('bill_id', $request->bill_id)
            ->first();
        switch ($request->pembagian_berdasarkan) {
            case 'waktu':
                $response = $this->cicilCalculateByWaktu($bill_detail, $request->pembagian_berkala);
                break;

            case 'jumlah_tagihan':
                $response = $this->cicilCalculateByJumlah($bill_detail, $request->pembagian_berkala);
                break;

            default:
                # code...
                break;
        }


        return response()->json($response);
    }

    public function storeSplitBill(Request $request)
    {
        $response = ['success' => true, 'description' => 'Tagihan Berhasil Menjadi Cicil!'];
        $bill_detail = BillDetail::with('bill')
            ->where('student_id', $request->student_id)
            ->where('bill_id', $request->bill_id)
            ->first();

        $old_id = $bill_detail->id;

        $data = [];
        switch ($request->pembagian_berdasarkan) {
            case 'waktu':
                $data = $this->cicilCalculateByWaktu($bill_detail, $request->pembagian_berkala);
                break;

            case 'jumlah_tagihan':
                $data = $this->cicilCalculateByJumlah($bill_detail, $request->pembagian_berkala);
                break;

            default:
                # code...
                break;
        }

        try {
            if (count($data) > 0) {
                foreach ($data['rows'] as $row) {
                    BillDetail::create([
                        'bill_id' => $request->bill_id,
                        'student_id' => $request->student_id,
                        'actived_at' => $row['actived_at'],
                        'amount' => $row['amount'],
                    ]);
                }
                $detail = BillDetail::findOrFail($old_id);
                $detail->delete();
            }
        } catch (\Throwable $th) {
            //throw $th;
            $response['success'] = false;
        }

        return response()->json($response);
    }


    private function cicilCalculateByWaktu($bill_detail, $division)
    {
        $name = $bill_detail->bill->name;
        $actived_at = $bill_detail->actived_at;
        $default_amount = $bill_detail->amount;
        $rows = [];
        $rows['amount_total'] = 0;
        for ($i = 1; $division >= $i; $i++) {
            $amount = $default_amount / $division;
            $rows['rows'][] = [
                'name' => 'CICIL ' . $name . ' KE ' . $i,
                'actived_at' => $actived_at,
                'amount' => ceil($amount),
            ];
            $rows['amount_total'] += ceil($amount);
        }


        return $rows;
    }

    private function cicilCalculateByJumlah($bill_detail, $division)
    {
        $name = $bill_detail->bill->name;
        $actived_at = $bill_detail->actived_at;
        $default_amount = $bill_detail->amount;
        $rows = [];
        $rows['amount_total'] = 0;
        for ($i = 1; 2 >= $i; $i++) {
            $amount = $i == 1 ? $division : $default_amount - $division;
            $rows['rows'][] = [
                'name' => 'CICIL ' . $name . ' KE ' . $i,
                'actived_at' => $actived_at,
                'amount' => ceil($amount),
            ];
            $rows['amount_total'] = ceil(($default_amount - $division) + $division);
        }


        return $rows;
    }
}
