<?php

namespace App\Http\Controllers\Ajax;

use App\Http\Controllers\Controller;
use GuzzleHttp\Client;
use Illuminate\Http\Request;

class LocationAjaxController extends Controller
{
    public function provinces(Client $client)
    {
        $response = client($client, route_api('api.location.provinces', [], CUSTOM_BASE_URL_API));

        return $response;
    }

    public function regencies(Client $client, $id)
    {
        $response = client($client, route_api('api.location.regencies', $id, CUSTOM_BASE_URL_API));

        return $response;
    }

    public function districts(Client $client, $id)
    {
        $response = client($client, route_api('api.location.districts', $id, CUSTOM_BASE_URL_API));

        return $response;
    }
    public function sub_districts(Client $client, $id)
    {
        $response = client($client, route_api('api.location.sub-districts', $id, CUSTOM_BASE_URL_API));

        return $response;
    }
}
