<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Bill;
use App\Models\BillDetail;
use Illuminate\Http\Request;

class BillApiController extends Controller
{
    public function show($id, $student_id, $status)
    {
        $billDetails = BillDetail::with('bill')
            ->where('bill_id', $id)
            ->where('student_id', $student_id)
            ->where('status', $status)
            // ->whereYear('actived_at', '<=', now()->year)
            // ->whereMonth('actived_at', '<=', now()->month)
            ->get();
        return datatables()->of($billDetails)->toJson();
    }
    
    
    public function bill($institution)
    {
        $bill = Bill::where('institution_id', $institution)->get();
        return datatables()->of($bill)->toJson();
    }
}
