<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class FinanceApiController extends Controller
{
    public function login(Request $request)
    {
        $credentials = $request->only('username', 'password');

        if (Auth::attempt($credentials)) {
            $user = Auth::user();

            $response = [
                'status' => 'success',
                'message' => 'Login successful.',
                'user' => $user,
                'institusi' => institution(),
            ];
        } else {
            $response = [
                'status' => 'error',
                'message' => 'Invalid username or password.'
            ];
        }

        return response()->json($response);
    }



     public function getTrxDay(Request $request)
    {
        $tglAwal = $request->input('tgl_awal');
        $tglAkhir = $request->input('tgl_akhir');
        $institution = $request->input('institution');

        $paidBills = DB::table('bill_details as bd')
            ->leftJoin('bills as b', 'bd.bill_id', '=', 'b.id')
            ->leftJoin('bill_categories as bc', 'b.bill_category_id', '=', 'bc.id')
            ->join('payments as p', 'bd.id', '=', 'p.bill_detail_id')
            ->join('students as s', 'bd.student_id', '=', 's.id')
            ->leftJoin('school_years as sy', 'b.school_year_id', '=', 'sy.id')
            ->where('bd.status', 'PAID')
            ->where('b.institution_id', $institution)
            ->whereBetween(DB::raw('DATE(bd.updated_at)'), [$tglAwal, $tglAkhir])
            ->groupBy('bd.id', 's.name', 'b.name', 'bd.month', 'bd.amount', 'bd.updated_at', 'bd.actived_at', 'bc.name', 's.nis')
            ->select('bd.id', 's.name as nama_santri', 'b.name as deskripsi', 'bd.month as bulan', 'bd.amount as nominal', 'bd.updated_at as tanggal', DB::raw('MONTH(bd.actived_at) as bulan_aktif'), DB::raw('YEAR(bd.actived_at) as tahun_aktif'), 'bc.name as kategori', 's.nis as nis_santri')
            ->get();

        return response()->json($paidBills);
    }
    public function getTrxMonth(Request $request)
    {
        $bulan = $request->input('bulan');
        $tp = $request->input('tp');
        $institution = $request->input('institution');
        $paidBills = DB::table('bill_details as bd')
            ->leftJoin('bills as b', 'b.id', '=', 'bd.bill_id')
            ->leftJoin('bill_categories as bc', 'b.bill_category_id', '=', 'bc.id')
            ->join('payments as p', 'bd.id', '=', 'p.bill_detail_id')
            ->join('students as s', 's.id', '=', 'bd.student_id')
            ->leftJoin('school_years as sy', 'sy.id', '=', 'b.school_year_id')
            ->where('bd.status', 'PAID')
            ->where('b.institution_id', $institution)
            ->whereMonth('bd.updated_at', $bulan)
            ->where('sy.id', $tp)
            ->groupBy('bd.id', 's.nis', 's.name', 'b.name', 'bd.amount', 'bd.updated_at',  'bd.actived_at', 'bc.name')
            ->select('bd.id', 's.nis as nis_santri', 's.name as nama_santri', 'b.name as deskripsi', 'bd.amount as nominal', 'bd.updated_at as tanggal', DB::raw('MONTH(bd.actived_at) as bulan_aktif'), DB::raw('YEAR(bd.actived_at) as tahun_aktif'), 'bc.name as kategori')
            ->get();


        return response()->json($paidBills);
    }

    public function getTrxBill(Request $request)
    {
        $tagihan = $request->input('tagihan');
        $status = $request->input('status');
        $institution = $request->input('institution');
        $mulai_dari = $request->input('mulai_dari');
        $sampai_dengan = $request->input('sampai_dengan');

        $query = DB::table('bill_details as bd')
            ->leftJoin('bills as b', 'b.id', '=', 'bd.bill_id')
            ->leftJoin('bill_categories as bc', 'b.bill_category_id', '=', 'bc.id')
            ->leftJoin('payments as p', 'bd.id', '=', 'p.bill_detail_id')
            ->join('students as s', 's.id', '=', 'bd.student_id')
            ->leftJoin('school_years as sy', 'sy.id', '=', 'b.school_year_id')
            ->where('b.institution_id', $institution)
            ->where('b.name', $tagihan);

        if ($status !== 'ALL') {
            $query->where('bd.status', $status);
        }
         if ($mulai_dari && $sampai_dengan) {
            $query->whereBetween(DB::raw('DATE(bd.actived_at)'), [$mulai_dari, $sampai_dengan]);
        }

        $paidBills = $query
            ->groupBy('bd.id', 's.name', 's.nis', 'b.name', 'bd.amount', 'bd.updated_at', 'bd.actived_at', 'bd.status', 'bc.name')
            ->select('bd.id', 'bd.status', 's.nis as nis_santri', 's.name as nama_santri', 'b.name as deskripsi', 'bd.amount as nominal', DB::raw('DATE(bd.updated_at) as tanggal'),'bd.actived_at', DB::raw('MONTH(bd.actived_at) as bulan_aktif'), DB::raw('YEAR(bd.actived_at) as tahun_aktif'), 'bc.name as kategori')
            ->get();

        return response()->json($paidBills);
    }
}
