<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Institution;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class InstitutionApiController extends Controller
{
    public function show()
    {
        $institutionsWithBillsAndDetailsAndStudents = Institution::with('bills.bill_detail.student')->get();

        return datatables()->of($institutionsWithBillsAndDetailsAndStudents)->toJson();
    }
    public function index()
    {
        $institution = Institution::all();
        return datatables()->of($institution)->toJson();
    }
    public function getInstitutionWithNis($institution, $nis)
    {
        $billDetails = DB::table('bill_details AS bd')
            ->select([
                'bd.id AS bill_detail_id',
                'b.id AS bill_id',
                's.id AS student_id',
                's.nis AS student_nis',
                'bd.amount',
                'i.name AS institution_name',
                'i.logo',
                'i.bank_account_number',
                DB::raw("IF(bd.month IS NULL, b.name, CONCAT(b.name, ' - ', DATE_FORMAT(bd.actived_at, '%b %y'))) AS bill_name"),
                's.name AS student_name',
            ])
            ->join('bills AS b', 'bd.bill_id', '=', 'b.id')
            ->join('institutions AS i', 'b.institution_id', '=', 'i.id')
            ->join('students AS s', 'bd.student_id', '=', 's.id')
            ->where('bd.status', '=', 'BILLED')
            ->where('b.institution_id', '=', $institution)
            ->where('s.nis', '=', $nis)
            ->whereBetween(DB::raw("DATE_FORMAT(bd.actived_at, '%Y-%m')"), [
                date('Y-01'),
                date('Y-m')
            ])
            ->orderByDesc('bd.actived_at')
            ->get();
        $totalAmount = $billDetails->sum('amount');
        $response = [
            'totalAmount' => $totalAmount,
            'billDetails' => $billDetails,
        ];
        return datatables()->of($response)->toJson();
    }
    public function getBillforSiri($nis)
    {
        $billDetails = DB::table('bill_details AS bd')
            ->select([
                'bd.id AS bill_detail_id',
                'b.id AS bill_id',
                's.id AS student_id',
                's.nis AS student_nis',
                'bd.amount',
                'bd.status AS bill_status',
                'i.name AS institution_name',
                'i.logo',
                'i.bank_account_number',
                'bd.actived_at',
                'bd.updated_at',
                DB::raw("IF(bd.month IS NULL, b.name, CONCAT(b.name, ' - ', DATE_FORMAT(bd.actived_at, '%b %y'))) AS bill_name"),
                's.name AS student_name',
            ])
            ->join('bills AS b', 'bd.bill_id', '=', 'b.id')
            ->join('institutions AS i', 'b.institution_id', '=', 'i.id')
            ->join('students AS s', 'bd.student_id', '=', 's.id')
            ->where('s.nis', '=', $nis)
            // ->whereBetween(DB::raw("DATE_FORMAT(bd.actived_at, '%Y-%m')"), [
            //     date('Y-01'),
            //     date('Y-m')
            // ])
            ->whereRaw("DATE_FORMAT(bd.actived_at, '%Y-%m') <= ?", [date('Y-m')])
            
            ->orderByDesc('bd.actived_at')
            ->get();

        $billedTotal = $billDetails->where('bill_status', 'BILLED')->sum('amount');
        $paidTotal = $billDetails->where('bill_status', 'PAID')->sum('amount');

        return datatables()->of($billDetails)
            ->with(['tertagih' => $billedTotal, 'terbayar' => $paidTotal])
            ->toJson();
    }
}

// public function show($id, $student_id, $status)
    // {
    //     $billDetails = BillDetail::with('bill')
    //         ->where('bill_id', $id)
    //         ->where('student_id', $student_id)
    //         ->where('status', $status)
    //         ->whereYear('actived_at', '<=', now()->year)
    //         ->whereMonth('actived_at', '<=', now()->month)
    //         ->get();
    //     return datatables()->of($billDetails)->toJson();
    // }