<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use GuzzleHttp\Client;

class LocationApiController extends Controller
{
    public function provinces()
    {
        $client = new Client();
        $response = $client->get('https://emsifa.github.io/api-wilayah-indonesia/api/provinces.json');
        $provinces = json_decode($response->getBody());
        $provinces = collect($provinces);

        return response()->json($provinces);
    }

    public function regencies($id)
    {
        $client = new Client();
        $response = $client->get('https://emsifa.github.io/api-wilayah-indonesia/api/regencies/' . $id . '.json');
        $regencies = json_decode($response->getBody());
        $regencies = collect($regencies);

        return response()->json($regencies);
    }

    public function districts($id)
    {
        $client = new Client();
        $response = $client->get('https://emsifa.github.io/api-wilayah-indonesia/api/districts/' . $id . '.json');
        $districts = json_decode($response->getBody());
        $districts = collect($districts);

        return response()->json($districts);
    }
    public function sub_districts($id)
    {
        $client = new Client();
        $response = $client->get('https://emsifa.github.io/api-wilayah-indonesia/api/villages/' . $id . '.json');
        $sub_districts = json_decode($response->getBody());
        $sub_districts = collect($sub_districts);

        return response()->json($sub_districts);
    }
}
