<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\SchoolClass;
use Illuminate\Http\Request;

class SchoolClassApiController extends Controller
{
    public function index($id)
    {
        $schoolClasses = SchoolClass::whereHas('educational_level', function ($query) use ($id) {
            $query->where('institution_id', $id);
        })->get();
        return datatables()->of($schoolClasses)->toJson();
    }

    public function batch($id)
    {
        $batch = SchoolClass::whereHas('educational_level', function ($query) use ($id) {
            $query->where('institution_id', $id);
        })->select('batch')
            ->groupBy('batch')->get();
        return datatables()->of($batch)->toJson();
    }
}
