<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Support\Facades\DB;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function insertBasicTableFormatted($model, $data, $notif, $originalName = null)
    {
        DB::beginTransaction(); // Memulai transaksi database

        try {
            if (isset($data['name']) && !is_null($originalName)) {
                $data['name'] = generateUniqueName($model, $originalName);
            }

            // Menghapus nilai null dari array $data
            removeNullValues($data);

            $model::create($data);

            // Jika tidak ada kesalahan, commit transaksi
            DB::commit();

            $notif['success'] = true;
        } catch (\Throwable $th) {
            // Jika terjadi kesalahan, rollback transaksi
            DB::rollBack();

            throw $th;
            $notif['status'] = 'notif-error';
            $notif['description'] = 'Gagal menambahkan data, silakan coba lagi!.'; // Diubah
            $notif['success'] = false;
        }

        return $notif;
    }

    public function updateBasicTableFormatted($model, $id, $data, $notif, $originalName = null)
    {
        DB::beginTransaction(); // Memulai transaksi database
        try {
            $bill = $model::findOrFail($id);

            if (isset($data['name']) && !is_null($originalName)) {
                $data['name'] = generateUniqueName($model, $originalName, $id);
            }

            // Menghapus nilai null dari array $data
            removeNullValues($data);

            $bill->update($data);

            DB::commit();

            $notif['success'] = true;
        } catch (\Throwable $th) {
            //throw $th;
            // Jika terjadi kesalahan, rollback transaksi
            DB::rollBack();

            $notif['status'] = 'notif-error';
            $notif['description'] = 'Gagal update data, silakan coba lagi!.'; // Diubah
            $notif['success'] = false;
        }

        return $notif;
    }

    public function deleteBasicTableFormatted($model, $ids = [], $notif = [])
    {
        DB::beginTransaction(); // Memulai transaksi database
        try {
            if (isset($ids[0]) && $ids[0] === 'on') {
                array_shift($ids);
            }

            if (is_array($ids) && count($ids) > 0) {
                $notif['ids'] = $ids;
                $model::whereIn('id', $ids)->delete();
            } else {
                $model::findOrFail($ids)->delete();
            }
        } catch (\Throwable $th) {
            // Jika terjadi kesalahan, rollback transaksi
            DB::rollBack();

            $notif['status'] = 'notif-error';
            $notif['success'] = false;

            $notif['description'] = $th->getMessage(); // Perubahan urutan

            if ($th->getCode() == 23000) {
                $notif['description'] = 'Data tidak dapat dihapus karena sudah diaplikasikan';
            } else {
                $notif['description'] = 'Gagal menghapus data, silakan coba lagi!';
            }
        } finally {
            DB::commit(); // Selalu selesaikan transaksi, baik berhasil maupun gagal
        }

        return $notif;
    }
}
