<?php

namespace App\Http\Controllers\Income;

use App\Http\Controllers\Controller;
use App\Models\EducationalLevel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;


class IncomeController extends Controller
{
    public function index()
    {
        $eduLevelIncome = DB::table('bill_details')
            ->leftJoin('students', 'bill_details.student_id', '=', 'students.id')
            ->leftJoin('school_classes', 'students.school_class_id', '=', 'school_classes.id')
            ->rightJoin('educational_levels', 'school_classes.educational_level_id', '=', 'educational_levels.id')
            ->leftJoin('institutions', 'institutions.id', '=', 'educational_levels.institution_id')
            ->where('educational_levels.institution_id', institution()->id)
            ->groupBy('educational_levels.id', 'educational_levels.institution_id', 'educational_levels.name', 'educational_levels.created_at', 'educational_levels.updated_at', 'institutions.name')
            ->select('educational_levels.*', 'institutions.name as instiName', DB::raw('SUM(bill_details.amount) as total'))
            ->get();
        $classIncome = DB::table('bill_details as bd')
            ->leftJoin('students as s', 'bd.student_id', '=', 's.id')
            ->rightJoin('school_classes as sc', 's.school_class_id', '=', 'sc.id')
            ->rightJoin('educational_levels as el', 'sc.educational_level_id', '=', 'el.id')
            ->where('el.institution_id', institution()->id)
            ->groupBy('sc.id', 'sc.name', 'el.name')
            ->select('sc.name', 'el.name as jenjang', DB::raw('SUM(bd.amount) as total'))
            ->get();
        $batchClassIncome = DB::table('bill_details as bd')
            ->leftJoin('students as s', 'bd.student_id', '=', 's.id')
            ->rightJoin('school_classes as sc', 's.school_class_id', '=', 'sc.id')
            ->rightJoin('educational_levels as el', 'sc.educational_level_id', '=', 'el.id')
            ->where('el.institution_id', institution()->id)
            ->groupBy('sc.batch', 'el.name')
            ->orderBy('sc.batch', 'ASC')
            ->select('el.name as jenjang', 'sc.batch', DB::raw('SUM(bd.amount) as total'))
            ->get();
        $billIncome = DB::table('bills as b')
            ->leftJoin('bill_details as bd', 'b.id', '=', 'bd.bill_id')
            ->where('b.institution_id', institution()->id)
            ->groupBy('b.name')
            ->select('b.name', DB::raw('SUM(bd.amount) as total'))
            ->get();

        $combinedData = array_merge($eduLevelIncome->toArray(), $classIncome->toArray(), $batchClassIncome->toArray(), $billIncome->toArray());
        $idEduLevelTable = 'eduLevelIncome-table';
        $idClassTable = 'classIncome-table';
        $idBatchTable = 'batchIncome-table';
        $idBillTable = 'billIncome-table';
        $headers = [
            'eduLevelIncomeHeaders' => [
                'No',
                'Ma`had',
                'Jenjang',
                'Pendapatan'
            ],
            'classIncomeHeaders' => [
                'No',
                'Jenjang',
                'Kelas',
                'Pendapatan'
            ],
            'batchIncomeHeaders' => [
                'No',
                'Jenjang',
                'Angkatan',
                'Pendapatan'
            ],
            'billIncomeHeaders' => [
                'No',
                'Nama Tagihan',
                'Pendapatan'
            ]
        ];
        $rowsEduLevel = [];
        $rowsClass = [];
        $rowsBatch = [];
        $rowsBill = [];

        $noEduLevel = 1;
        $noClass = 1;
        $noBatch = 1;
        $noBill = 1;

        foreach ($combinedData as $row) {
            if (isset($row->instiName)) {
                $rowsEduLevel[] = [
                    $noEduLevel++,
                    $row->instiName,
                    $row->name,
                    'Rp. ' . number_format($row->total, 0, ',', '.') . ','
                ];
            } elseif (isset($row->jenjang) && isset($row->name)) {
                $rowsClass[] = [
                    $noClass++,
                    $row->jenjang,
                    $row->name, // Nama kelas
                    'Rp. ' . number_format($row->total, 0, ',', '.') . ','
                ];
            } elseif (isset($row->jenjang) && isset($row->batch)) {
                $rowsBatch[] = [
                    $noBatch++,
                    $row->jenjang,
                    $row->batch,
                    'Rp. ' . number_format($row->total, 0, ',', '.') . ','
                ];
            } elseif (!empty($row->name)) {
                $rowsBill[] = [
                    $noBill++,
                    $row->name,
                    'Rp. ' . number_format($row->total, 0, ',', '.') . ','
                ];
            }
        }



        $eduLevelIncomeTotal = DB::table(DB::raw('(select el.*, sum(amount) total from bill_details bd
            left join students s on bd.student_id=s.id
            left join school_classes sc on s.school_class_id=sc.id
            right join educational_levels el on sc.educational_level_id=el.id
            WHERE el.institution_id = ' . institution()->id . '
            GROUP BY el.id, el.institution_id,el.name,el.created_at,el.updated_at) total_jenjang'))
            ->select(DB::raw('SUM(total) as total'))
            ->get();




        $classIncomeTotal = DB::table(DB::raw('(select sc.name,sum(amount) total from bill_details bd left join students s on bd.student_id=s.id right join school_classes sc on s.school_class_id=sc.id right join educational_levels el on sc.educational_level_id=el.id WHERE el.institution_id = ' . institution()->id . ' GROUP BY sc.id,sc.name) as totalKelas'))
            ->select(DB::raw('SUM(total) as total'))
            ->get();



        $batchClassIncomeTotal = DB::table(DB::raw('(select sc.batch, sum(amount) total from bill_details bd
            left join students s on bd.student_id=s.id
            right join school_classes sc on s.school_class_id=sc.id
            right join educational_levels el on sc.educational_level_id=el.id
            WHERE el.institution_id = ' . institution()->id . '
            GROUP BY sc.batch) as totalKelas'))
            ->select(DB::raw('SUM(total) as total'))
            ->get();



        $billIncomeTotal = DB::table(DB::raw('(select b.name, sum(amount) total from bills b
            left join bill_details bd on b.id=bd.bill_id
            where b.institution_id = ' . institution()->id . '
            group by b.id, b.name) as tagihan'))
            ->select(DB::raw('SUM(total) as total'))
            ->get();


        return view('pages.institution.report.income.index', compact('eduLevelIncome', 'eduLevelIncomeTotal', 'classIncome', 'classIncomeTotal', 'batchClassIncome', 'batchClassIncomeTotal', 'billIncome', 'billIncomeTotal', 'headers', 'rowsEduLevel', 'idEduLevelTable', 'idClassTable', 'rowsClass', 'idBatchTable', 'rowsBatch', 'idBillTable', 'rowsBill'));
        // $eduLevels = EducationalLevel::all();
        // $idEduLevelTable = 'edulevel-table';
        // $idSchoolClassTable = 'school-class-table';
        // $idBatchTable = 'batch-table';
        // $idBillTable = 'bill-table';
        // $headers = [
        //     'EduLevel' => [
        //         'No',
        //         "Ma'had",
        //         'Jenjang',
        //         'Pendapatan',
        //     ],
        //     'Batch' => [
        //         'No',
        //         'Jenjang',
        //         'Angkatan',
        //         'Pendapatan',
        //     ],
        //     'Class' => [
        //         'No',
        //         'Jenjang',
        //         'Kelas',
        //         'Pendapatan',
        //     ],
        //     'Bill' => [
        //         'No',
        //         'Nama Tagihan',
        //         'Pendapatan'
        //     ]
        // ];
        // $rows = [
        //     'EduLevel' => [
        //         [
        //             1,
        //             'NURUL HAYAH ||',
        //             'SMP/MTs',
        //             'Rp15.050.780.000',
        //         ],
        //     ],
        //     'Batch' => [
        //         [
        //             1,
        //             'SMP/MTs',
        //             '7',
        //             'Rp15.050.780.000',
        //         ],
        //         [
        //             2,
        //             'SMP/MTs',
        //             '8',
        //             'Rp15.050.780.000',
        //         ],
        //         [
        //             3,
        //             'SMP/MTs',
        //             '9',
        //             'Rp15.050.780.000',
        //         ],
        //     ],
        //     'Class' => [
        //         [
        //             1,
        //             'SMP/MTs',
        //             '7-A MTs',
        //             'Rp15.050.780.000',
        //         ],
        //         [
        //             2,
        //             'SMP/MTs',
        //             '7-B MTs',
        //             'Rp15.050.780.000',
        //         ],
        //         [
        //             3,
        //             'SMP/MTs',
        //             '8-A MTs',
        //             'Rp15.050.780.000',
        //         ],
        //         [
        //             4,
        //             'SMP/MTs',
        //             '8-B MTs',
        //             'Rp15.050.780.000',
        //         ],
        //         [
        //             5,
        //             'SMP/MTs',
        //             '9-A MTs',
        //             'Rp15.050.780.000',
        //         ],
        //         [
        //             6,
        //             'SMP/MTs',
        //             '9-B MTs',
        //             'Rp15.050.780.000',
        //         ],
        //         [
        //             7,
        //             'SMP/MTs',
        //             '9-C MTs',
        //             'Rp15.050.780.000',
        //         ],
        //     ],
        //     'Bill' => [
        //         [
        //             1,
        //             'Syariah',
        //             'Rp15.050.780.000',
        //         ],
        //         [
        //             2,
        //             'Daftar Ulang Kelas 8',
        //             'Rp15.050.780.000',
        //         ],
        //         [
        //             3,
        //             'Daftar Ulang Kelas 9',
        //             'Rp15.050.780.000',
        //         ],
        //         [
        //             4,
        //             'Intensif Dwi Bahasa',
        //             'Rp15.050.780.000',
        //         ],
        //         [
        //             5,
        //             'Kitab Madrasah',
        //             'Rp15.050.780.000',
        //         ],
        //     ],
        // ];
        // $no = 0;
        // foreach($eduLevels as $eduLevel) {
        //     $rows[] = [
        //         $no++,
        //         $eduLevel,
        //         $eduLevel,
        //         $eduLevel,
        //     ];
        // }
        //     return view('pages.institution.report.income.index', compact(
        //         'idEduLevelTable',
        //         'idSchoolClassTable',
        //         'idBatchTable',
        //         'idBillTable',
        //         'headers',
        //         'rows',
        //     ));
    }
}
