<?php

namespace App\Http\Controllers\Student;

use App\Http\Controllers\Controller;
use App\Models\Bill;
use App\Models\BillDetail;
use App\Models\Payment;
use Illuminate\Http\Request;

class StudentBillController extends Controller
{
    public function updateActivedAt(Request $request)
    {
        $notif = ['success' => true, 'description' => 'Tanggal Aktif Berhasil Di Update!'];
        $data = $request->only(['student_id', 'bill_id', 'actived_at']);

        try {
            BillDetail::where('student_id', $data['student_id'])
                ->where('bill_id', $data['bill_id'])
                ->update(['actived_at' => $data['actived_at']]);
        } catch (\Throwable $th) {
            //throw $th;
            $notif['success'] = false;
            // $notif['description'] = $th->getMessage();
            $notif['description'] = 'Tanggal Aktif Gagal Di Update!';
        }

        return response()->json($notif);
    }


    public function edit($id, $bill_id)
    {
        $student_id = $id;
        $bill_id = $bill_id;
        $bill = Bill::findOrFail($bill_id);
        $bill_details = BillDetail::with('bill', 'student')
            ->where('student_id', $id)
            ->where('bill_id', $bill_id)
            ->get();

        $amount = BillDetail::with('bill', 'student')
            ->where('student_id', $id)
            ->where('bill_id', $bill_id)
            ->sum('amount');

        return view('pages.institution.manage-data.student.edit-bill', compact(
            'bill_details',
            'bill',
            'student_id',
            'bill_id',
            'amount',
        ));
    }

    public function destroy(Request $request)
    {
        $notif = ['status' => 'notif-success', 'description' => 'Berhasil hapus data!'];
        $ids = empty($request->ids) || !isset($request->ids) ? $request->id_confirm : $request->ids;

        try {
            if ($ids['0'] == 'on') {
                \array_shift($ids);
            }
            if (is_array($ids) && count($ids) > 0) {
                // Multi-delete
                foreach ($ids as $id) {
                    $bill_detail = BillDetail::where('id', $id)->first();
                    BillDetail::where('student_id', $request->student_id)
                        ->where('bill_id', $bill_detail->bill_id)
                        ->delete();
                }
            } else {
                // Single-delete
                $billDetails = BillDetail::where('id', $request->id_confirm)->first();
                BillDetail::where('student_id', $request->student_id)
                    ->where('bill_id', $billDetails->bill_id)->delete();
            }
        } catch (\Throwable $th) {
            $notif['status'] = 'notif-error';
            $notif['description'] = 'Gagal menghapus data, Silahkan coba lagi!.';
            $notif['error'] = $th->getMessage();
        }
        $notif['ids'] = $ids;
        return response()->json($notif);
    }

    public function unpaid(Request $request)
    {
        $notif = ['status' => 'notif-success', 'description' => 'Berhasil hapus data!'];
        $ids = empty($request->ids) || !isset($request->ids) ? $request->id_confirm : $request->ids;

        try {
            if ($ids['0'] == 'on') {
                \array_shift($ids);
            }
            if (is_array($ids) && count($ids) > 0) {
                // Multi-unpaid
                foreach ($ids as $id) {
                    $bill_detail = BillDetail::where('id', $id)->first();
                    BillDetail::where('student_id', $request->student_id)
                        ->where('bill_id', $bill_detail->bill_id)
                        ->update(['status' => 'BILLED']);
                }
            } else {
                // Single-delete
                $billDetails = BillDetail::where('id', $request->id_confirm)->first();
                BillDetail::where('student_id', $request->student_id)
                    ->where('bill_id', $billDetails->bill_id)->update(['status' => 'BILLED']);
            }
        } catch (\Throwable $th) {
            $notif['status'] = 'notif-error';
            $notif['description'] = 'Gagal menghapus data, Silahkan coba lagi!.';
            $notif['error'] = $th->getMessage();
        }

        return response()->json($notif);
    }

    public function update(Request $request)
    {
        $notif = ['success' => true, 'description' => 'Berhasil update data!'];
        $ids = $request->ids ?? [];

        try {
            if ($ids['0'] == 'on') {
                \array_shift($ids);
            }
            // Multi-update
            $billDetails = BillDetail::with('bill')->whereIn('id', $ids)
                ->get();
            // $notif['category'] = $billDetails->bill->bill_category_id;
            foreach ($billDetails as $billDetail) {
                $billDetail->update(['status' => 'PAID', 'paid_at' => now()->format('Y-m-d')]);
            }
        } catch (\Throwable $th) {
            $notif['description'] = 'Gagal update data, Silahkan coba lagi!.';
            $notif['error'] = $th->getMessage();
            if ($notif['error'] == 'Undefined array key 0') {
                $notif['error'] = 'Mohon dichecklist terlebih dahulu!';
            }
            $notif['success'] = false;
        }

        return response()->json($notif);
    }

    public function search(Request $request, $id, $bill_id)
    {
        $searchTerm = $request->input('searchTerm'); // Mendapatkan kata kunci pencarian dari permintaan

        // Lakukan pencarian berdasarkan kata kunci pada model BillDetail
        $results = BillDetail::with('bill', 'student')
            ->where('student_id', $id)
            ->where('bill_id', $bill_id)
            ->where('actived_at', 'LIKE', "%$searchTerm%")
            ->orderByRaw("YEAR(`actived_at`) ASC, MONTH(`actived_at`) ASC")
            ->get();

        return response()->json($results);
    }
}
