<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\ApiToken;

class ApiTokenIsValid
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        // Check if the Authorization header is present in the request
        if (!$request->hasHeader('Authorization')) {
            return response()->json(['message' => 'Authorization header missing'], 401);
        }

        // Get the token from the Authorization header
        $token = $request->bearerToken();

        // Check if the token is valid
        if (!$this->checkKey($token)) {
            return response()->json(['message' => 'Invalid token'], 403);
        }

        return $next($request);
    }

    public function checkKey($apiKey)
    {
        return ApiToken::where('access_token', $apiKey)->exists();
    }
}
