<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class InstitutionStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => ['required', 'unique:institutions'],
            'institution' => ['required', 'unique:institutions'],
            'bank_account_number' => ['required', 'unique:institutions'],
            'bank_account_holder_name' => ['required', 'unique:institutions'],
            'email' => ['required', 'unique:institutions'],
            'admin_name' => ['required'],
            'admin_username' => ['required', 'unique:users,username'],
            'admin_email' => ['required', 'email:dns', 'unique:users,email']
        ];
    }
}
