<?php

namespace App\Imports;

use App\Models\SchoolClass;
use App\Models\Student;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;

class StudentSheet implements ToModel, WithHeadingRow, WithValidation
{
    use Importable;
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        // dd($row);
        $schoolClass = SchoolClass::where('code', $row['kelas'])->first();
        return new Student([
            'name' => $row['nama'],
            'nis' => $row['nis'],
            'school_class_id' => $schoolClass->id,
            'phone' => $row['telepon']
        ]);
    }

    public function rules(): array
    {
        return [
            'nama' => 'required',
            'kelas' => 'required',
            'nis' => 'required|unique:students',
        ];
    }
}
