<?php

namespace App\Observers;

use App\Models\BillDetail;
use App\Models\Payment;

class BillDetailObserver
{
    /**
     * Handle the BillDetail "created" event.
     *
     * @param  \App\Models\BillDetail  $billDetail
     * @return void
     */
    public function created(BillDetail $billDetail)
    {
        //
    }

    /**
     * Handle the BillDetail "updated" event.
     *
     * @param  \App\Models\BillDetail  $billDetail
     * @return void
     */
    public function updated(BillDetail $billDetail)
    {
        if ($billDetail->isDirty('status')) {
            Payment::create([
                'pay_code' => \generatePayCode('BILL'),
                'bill_detail_id' => $billDetail->id,
                'student_id' => $billDetail->student_id,
                'amount' => $billDetail->amount,
                'description' => 'Transaksi',
            ]);
        }
    }

    /**
     * Handle the BillDetail "deleted" event.
     *
     * @param  \App\Models\BillDetail  $billDetail
     * @return void
     */
    public function deleted(BillDetail $billDetail)
    {
        //
    }

    /**
     * Handle the BillDetail "restored" event.
     *
     * @param  \App\Models\BillDetail  $billDetail
     * @return void
     */
    public function restored(BillDetail $billDetail)
    {
        //
    }

    /**
     * Handle the BillDetail "force deleted" event.
     *
     * @param  \App\Models\BillDetail  $billDetail
     * @return void
     */
    public function forceDeleted(BillDetail $billDetail)
    {
        //
    }
}
