<?php

use App\Models\Payment;
use Carbon\Carbon;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Lang;
use Services\ManageDataService;

//? > ini url kalo kamu menggunakan artisan serve dan masih di local
// const CUSTOM_BASE_URL_API = 'http://localhost/edupay/public';
//? > ini url kalo kamu sudah production
const CUSTOM_BASE_URL_API = '';

/**
 * check name route, that's function for menu sidebar
 * @return this function use request()->routeIs($route) for return
 */
if (!function_exists('is_route')) {
    function is_route($route, $if, $else = false)
    {
        return in_array(request()->routeIs($route), [true]) ? $if : ($else ?? '');
    }
}


if (!function_exists('generateUniqueName')) {
    function generateUniqueName($model, $originalName, $id = null)
    {
        $name = $originalName;
        $count = 1;

        $existingRecord = $model::where('name', $name)->first();

        if ($existingRecord && (is_null($id) || $existingRecord->id != $id)) {
            if ($existingRecord->institution_id == institution()->id) {
                while ($model::where('name', $name)->exists()) {
                    $name = $originalName . ' (' . $count . ')';
                    $count++;
                }
            }
        }

        return $name;
    }
}

if (!function_exists('deleteBasicTableFormatted')) {
    function deleteBasicTableFormatted($model, $ids = [], $notif = [])
    {
        DB::beginTransaction(); // Memulai transaksi database
        try {
            if (isset($ids[0]) && $ids[0] === 'on') {
                array_shift($ids);
            }

            if (is_array($ids) && count($ids) > 0) {
                $notif['ids'] = $ids;
                $model::whereIn('id', $ids)->delete();
            } else {
                $model::findOrFail($ids)->delete();
            }
        } catch (\Throwable $th) {
            // Jika terjadi kesalahan, rollback transaksi
            DB::rollBack();

            $notif['status'] = 'notif-error';
            $notif['success'] = false;

            $notif['description'] = $th->getMessage(); // Perubahan urutan

            if ($th->getCode() == 23000) {
                $notif['description'] = 'Data tidak dapat dihapus karena sudah diaplikasikan';
            } else {
                $notif['description'] = 'Gagal menghapus data, silakan coba lagi!'; // Diubah
            }
        } finally {
            DB::commit(); // Selalu selesaikan transaksi, baik berhasil maupun gagal
        }

        return $notif;
    }
}


if (!function_exists('removeNullValues')) {
    function removeNullValues(&$data)
    {
        foreach ($data as $key => $value) {
            if (is_null($value)) {
                unset($data[$key]);
            }
        }
    }
}

if (!function_exists('insertBasicTableFormatted')) {
    function insertBasicTableFormatted($model, $data, $notif, $originalName = null)
    {
        DB::beginTransaction(); // Memulai transaksi database

        try {
            if (isset($data['name']) && !is_null($originalName)) {
                $data['name'] = generateUniqueName($model, $originalName);
            }

            // Menghapus nilai null dari array $data
            removeNullValues($data);

            $model::create($data);

            // Jika tidak ada kesalahan, commit transaksi
            DB::commit();

            $notif['success'] = true;
        } catch (\Throwable $th) {
            // Jika terjadi kesalahan, rollback transaksi
            DB::rollBack();

            throw $th;
            $notif['status'] = 'notif-error';
            $notif['description'] = 'Gagal menambahkan data, silakan coba lagi!.'; // Diubah
            $notif['success'] = false;
        }

        return $notif;
    }
}

if (!function_exists('updateBasicTableFormatted')) {
    function updateBasicTableFormatted($model, $id, $data, $notif, $originalName = null)
    {
        DB::beginTransaction(); // Memulai transaksi database
        try {
            $bill = $model::findOrFail($id);

            if (isset($data['name']) && !is_null($originalName)) {
                $data['name'] = generateUniqueName($model, $originalName, $id);
            }

            // Menghapus nilai null dari array $data
            removeNullValues($data);

            $bill->update($data);

            DB::commit();

            $notif['success'] = true;
        } catch (\Throwable $th) {
            //throw $th;
            // Jika terjadi kesalahan, rollback transaksi
            DB::rollBack();

            $notif['status'] = 'notif-error';
            $notif['description'] = 'Gagal update data, silakan coba lagi!.'; // Diubah
            $notif['success'] = false;
        }

        return $notif;
    }
}

if (!function_exists('institution')) {
    function institution()
    {
        $institution = \App\Models\Institution::where('id', auth()->user()->institution_id)->first();
        return $institution;
    }
}

if (!function_exists('carbon')) {
    function carbon()
    {
        return new Carbon();
    }
}


//! NOT WORKING
function generatePayCode($prefix)
{
    // Mendapatkan tahun 2 digit dari tanggal
    $tahun = date('y');

    // Mendapatkan bulan dari tanggal
    $bulan = date('m');

    // Mendapatkan tanggal dari tanggal
    $tanggal = date('d');

    // Mendapatkan nomor urut dari database atau penyimpanan lainnya
    $nomorUrut = getOrderNumber();

    // Format nomor urut menjadi 4 digit dengan leading zeros
    $nomorUrut = str_pad($nomorUrut, 4, '0', STR_PAD_LEFT);

    // Gabungkan semua komponen menjadi kode lengkap
    $kode = $prefix . $tahun . $bulan . $tanggal . $nomorUrut;

    return $kode;
}


//! NOT WORKING
function getOrderNumber()
{
    // Ambil tanggal terakhir reset dari database
    $lastResetDate = Payment::max('last_reset_date');
    $today = now()->format('Y-m-d');

    // Jika tanggal terakhir reset sama dengan tanggal hari ini,
    // gunakan nomor urut terakhir dan tambahkan 1
    if ($lastResetDate && $lastResetDate == $today) {
        $lastPayment = Payment::whereDate('last_reset_date', $today)->latest()->first();
        if ($lastPayment) {
            $nomorUrut = intval(substr($lastPayment->pay_code, -4)) + 1;
        } else {
            $nomorUrut = 1;
        }
    } else {
        // Jika tanggal terakhir reset tidak sama dengan tanggal hari ini,
        // reset nomor urut menjadi 1
        Payment::whereDate('last_reset_date', $today)->update(['last_reset_date' => $today]);
        $nomorUrut = 1;
    }

    return str_pad($nomorUrut, 4, '0', STR_PAD_LEFT);
}

function lastBillPayment()
{
    $kdhuruf = 'BIL';
    $tanggal = Carbon::now()->format('ymd');
    $tglnow = Carbon::now()->format('Y-m-d');

    $cek = DB::table('payments')
        ->select(DB::raw('RIGHT(pay_code, 4) as nomor'))
        ->whereDate('last_reset_date', $tglnow)
        ->orderByDesc('id')
        ->first();

    if (!$cek) {
        $kode = $kdhuruf . $tanggal . '0001';
    } else {
        $nomorDaftar = intval($cek->nomor);
        $nomorNext = $nomorDaftar + 1;
        $kode = $kdhuruf . $tanggal . sprintf('%04d', $nomorNext);
    }

    return $kode;
}


function formatToIndonesianDate($dateString)
{
    $date = Carbon::parse($dateString);
    $bulan = Lang::get('date.months', [], 'id');
    $formattedDate = $date->isoFormat('DD') . ' ' . $bulan[$date->month - 1] . ' ' . $date->year;

    return $formattedDate;
}

function client(Client $client, $uri, $method = 'GET', $body = null)
{
    $response = $client->request($method, $uri, [
        'headers' => [
            'Authorization' => 'Bearer ' . config('api.access_token'),
        ],
        'body' => $body,
        'verify' => false,
    ]);

    $body = $response->getBody()->getContents();

    // Cek apakah respons adalah JSON yang valid
    $data = json_decode($body, true);

    if ($data === null && json_last_error() !== JSON_ERROR_NONE) {
        // Penanganan kesalahan jika parsing JSON gagal
        return response()->json(['error' => 'Invalid JSON response'], 500);
    }

    // Sekarang Anda memiliki data yang dapat digunakan
    $response = collect($data);

    return response()->json($response);
}

function manageData()
{
    return ManageDataService::getInstance();
}

function route_api($name, $parameters = [], $baseURL = null)
{
    $route = route($name, $parameters);
    // Periksa apakah $baseURL adalah NULL atau string kosong
    if ($baseURL !== null && strlen($baseURL) > 0) {
        $route = route($name, $parameters, false);
        $route = $baseURL . $route;
    }
    return $route;
}
if (!function_exists('namaBulanIndonesia')) {
    function namaBulanIndonesia($bulan)
    {
        $bulanIndonesia = [
            "Januari", "Februari", "Maret", "April", "Mei", "Juni",
            "Juli", "Agustus", "September", "Oktober", "November", "Desember"
        ];

        if ($bulan >= 1 && $bulan <= 12) {
            return $bulanIndonesia[$bulan - 1];
        } else {
            return "";
        }
    }
}

