<?php

namespace Database\Seeders;

use App\Models\Bill;
use App\Models\BillDetail;
use Illuminate\Database\Seeder;

class BillDetailSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $rows = [];

        $bill = Bill::with('school_year')->findOrFail(1);

        for ($i = 1; $i <= 12; $i++) {
            $row = [
                'bill_id' => 1,
                'student_id' => 1,
            ];
            $row['month'] = $i;
            $row['amount'] = 750000;
            if ($i < 7) {
                $row['actived_at'] = $bill->school_year->end_year . '-0' . $i . '-01';
            } else {
                $row['actived_at'] = $bill->school_year->start_year . '-0' . $i . '-01';
            }

            $rows[] = $row;
        }
        for ($i = 1; $i <= 12; $i++) {
            $row = [
                'bill_id' => 1,
                'student_id' => 2,
            ];
            $row['month'] = $i;
            $row['amount'] = 750000;
            if ($i < 7) {
                $row['actived_at'] = $bill->school_year->end_year . '-0' . $i . '-01';
            } else {
                $row['actived_at'] = $bill->school_year->start_year . '-0' . $i . '-01';
            }

            $rows[] = $row;
        }

        foreach ($rows as $row) {
            BillDetail::create($row);
        }

        // BillDetail::create([
        //     'bill_id' => 2,
        //     'amount' => 2500000,
        //     'actived_at' => now(),
        // ]);
        // BillDetail::create([
        //     'bill_id' => 2,
        //     'amount' => 2500000,
        //     'actived_at' => now(),
        // ]);

        // BillDetail::create([
        //     'bill_id' => 3,
        //     'amount' => 500000,
        //     'actived_at' => now(),
        // ]);

        BillDetail::create([
            'bill_id' => 4,
            'student_id' => 1,
            'amount' => 300000,
            'actived_at' => now(),
        ]);
    }
}
