@push('css')
<link rel="stylesheet" href="{{ asset('assets/vendor/libs/dataTables/dataTables.bootstrap5.min.css') }}">
<style>
    .table-loader {
        visibility: hidden;
    }

    .table-loader:before {
        visibility: visible;
        display: table-caption;
        content: " ";
        width: 100%;
        height: 200px;
        background-image:
            linear-gradient(rgba(235, 235, 235, 1) 1px, transparent 0),
            linear-gradient(90deg, rgba(235, 235, 235, 1) 1px, transparent 0),
            linear-gradient(90deg, rgba(255, 255, 255, 0), rgba(255, 255, 255, 0.5) 15%, rgba(255, 255, 255, 0) 30%),
            linear-gradient(rgba(240, 240, 242, 1) 35px, transparent 0);

        background-repeat: repeat;

        background-size:
            1px 35px,
            calc(100% * 0.1666666666) 1px,
            30% 100%,
            2px 70px;

        background-position:
            0 0,
            0 0;

        animation: shine 0.5s infinite;
    }

    @keyframes shine {
        to {
            background-position:
                0 0,
                0 0,
                40% 0,
                0 0;
        }
    }

    #user-table_wrapper>.row {
        /* gap: 1rem; */
    }
</style>
@endpush
{{-- <div id="loading">
    <div class="d-flex justify-content-center align-items-center w-full" style="height: 100px">
        <div class="sk-bounce sk-primary">
            <div class="sk-bounce-dot"></div>
            <div class="sk-bounce-dot"></div>
        </div>
    </div>
</div> --}}
<div class="table-responsive text-nowrap">

    <table class="table table-bordered table-sm p-2" id="{{ $id }}" style="display: none">
        <thead>
            <tr>

                @isset($headers)
                @empty(!$headers)
                @foreach ($headers as $header)
                <th class="text-center">{{ $header }}</th>
                @endforeach
                <th class="text-center">actions</th>
                @endempty
                @endisset
            </tr>
        </thead>
        <tbody>
            @isset($rows)
            @empty(!$rows)
            @foreach ($rows as $row)
            <tr>
                @foreach ($row as $cell)
                @if ($cell == $loop->first)

                @endif
                <td class="text-center">{!! $cell !!}</td>
                @endforeach
            </tr>
            @endforeach
            @endempty
            @endisset
        </tbody>
    </table>

</div>

@push('js')
<!-- include jQuery -->
<script src="http://ajax.googleapis.com/ajax/libs/jquery/1/jquery.js"></script>
<!-- include BlockUI -->
<script src="https://cdn.jsdelivr.net/npm/jquery-blockui@2.7.0/jquery.blockUI.min.js"></script>
<script src="{{ asset('assets/vendor/libs/dataTables/dataTables.min.js') }}"></script>
<script src="{{ asset('assets/vendor/libs/dataTables/dataTables.bootstrap5.min.js') }}"></script>
<script src="https://cdn.datatables.net/buttons/1.7.1/js/dataTables.buttons.min.js"></script>

@endpush