@extends('layouts.dashboard', ['title' => 'Lembaga Pendidikan'])

@section('content')
    <div class="row">
        <h4 class="fw-bold py-3 mb-4">
            <span class="text-muted fw-light skeleton"><a href="/">Dashboard</a>
                /</span>
            <span class="skeleton">Lembaga Pendidikan</span>
        </h4>
        <div class="col">
            <div class="card">
                <div class="card-body">
                    <x-basic-data-table :id="$idInstitutionTable" :routeDelete="route('admin.institution.destroy')" :headers="$headers" :rows="$rows" />
                </div>
            </div>
        </div>
    </div>

    @push('show-modal')
        @php
            $formModal = 'formInstitutionModal';
        @endphp
        {{-- FORM MODAL --}}
        <x-show-modal :id="$formModal">
            <div class="modal-header">
                <h5 class="modal-title" id="modalToggleLabel">
                    <div id="modalToggleLabel2"></div>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="formInstitution" action="{{ route('admin.institution.store') }}" method="POST"
                    enctype="multipart/form-data">
                    @csrf
                    @method('POST')
                    <div class="row">
                        <h5 class="text-primary mb-4">Data Lembaga</h5>
                        @field([
                            'label' => 'Rekening BSN',
                            'name' => 'bank_account_number',
                            'placeholder' => 'xxxxxxxxx',
                            'type' => 'text',
                        ])
                        @field([
                            'label' => 'Nama Rekening',
                            'name' => 'bank_account_holder_name',
                            'placeholder' => 'Nurul Hayah 4',
                            'type' => 'text',
                        ])
                        @field([
                            'label' => 'Nama Lembaga',
                            'name' => 'name',
                            'placeholder' => 'NURUL HAYAH',
                            'type' => 'text',
                        ])
                        <input type="hidden" name="province_hide" value="{{ old('province_hide') }}">
                        <input type="hidden" name="regency_hide" value="{{ old('regency_hide') }}">
                        <input type="hidden" name="district_hide" value="{{ old('district_hide') }}">
                        <input type="hidden" name="sub_district_hide" value="{{ old('sub_district_hide') }}">
                        @field([
                            'label' => 'Alamat',
                            'name' => 'province',
                            'type' => 'select',
                            'options' => '<option value="">Pilih Provinsi</option>',
                        ])
                        @field([
                            'label' => '',
                            'name' => 'regency',
                            'type' => 'select',
                            'options' => '<option value="">Pilih Kabupaten</option>',
                        ])
                        <div class="d-flex gap-5">
                            <div class="col">
                                @field([
                                    'label' => '',
                                    'name' => 'district',
                                    'type' => 'select',
                                    'options' => '<option value="">Pilih Kecamatan</option>',
                                ])
                            </div>
                            <div class="col">
                                @field([
                                    'label' => '',
                                    'name' => 'sub_district',
                                    'type' => 'select',
                                    'options' => '<option value="">Pilih Kelurahan</option>',
                                ])
                            </div>
                        </div>
                        @field([
                            'label' => 'Email',
                            'name' => 'email',
                            'placeholder' => 'info@nurulhayah4.com',
                            'type' => 'text',
                        ])
                        <h5 class="text-primary my-4">Data Edupay Lembaga</h5>
                        @field([
                            'label' => 'ID Edupay',
                            'name' => 'institution',
                            'placeholder' => '10635',
                            'type' => 'text',
                        ])
                        @field([
                            'label' => 'Rekening BSN',
                            'name' => 'clone_bank_account_number',
                            'placeholder' => 'xxxxxxxxx',
                            'readonly' => true,
                            'type' => 'text',
                        ])
                        @field([
                            'label' => 'Nama Rekening',
                            'name' => 'clone_bank_account_holder_name',
                            'placeholder' => 'Nurul Hayah 4',
                            'readonly' => true,
                            'type' => 'text',
                        ])
                        <div class="mb-3">
                            <label class="form-label" for="logo">Logo</label>
                            <img class="img-preview img-fluid mb-3 col-sm-5" style="border-radius: 5px">
                            <input class="form-control skeleton" type="hidden" id="old_logo" name="old_logo_file" />
                            <input class="form-control skeleton @error('logo_file') is-invalid @enderror" type="file"
                                id="logo" name="logo_file" onchange="previewImage('#logo', '.img-preview')" />
                            @error('logo_file')
                                <div class="fv-plugins-message-container invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <h5 class="text-primary my-4">Data Adminitstrator</h5>
                        @field([
                            'label' => 'Nama Lengkap',
                            'name' => 'admin_name',
                            'placeholder' => 'Abdurrahman Alfarabi',
                            'type' => 'text',
                        ])
                        @field([
                            'label' => 'Username',
                            'name' => 'admin_username',
                            'placeholder' => 'abdrrahman',
                            'type' => 'text',
                        ])
                        @field([
                            'label' => 'No. Telepon',
                            'name' => 'admin_phone',
                            'placeholder' => '0852 9878 7789',
                            'type' => 'text',
                        ])
                        @field([
                            'label' => 'Email',
                            'name' => 'admin_email',
                            'placeholder' => 'robi@gmail.com',
                            'type' => 'email',
                        ])
                        @field([
                            'label' => 'Password',
                            'name' => 'admin_pass',
                            'placeholder' => '&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;',
                            'type' => 'password',
                        ])
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                    Batal
                </button>
                <button type="submit" class="btn btn-primary">
                    Simpan
                </button>
            </div>
            </form>
        </x-show-modal>
    @endpush
    @push('js')
        <!-- Include Utils -->
        <script src="{{ asset('assets/js/utils.js') }}"></script>

        <!-- Setup DataTable -->
        <script src="{{ asset('assets/js/basic-table-ajax.js') }}"></script>

        <script>
            $(document).ready(function() {

                $('#regency').attr('disabled', true)
                $('#district').attr('disabled', true)
                $('#sub_district').attr('disabled', true)

                let idTable = "#:id".replace(":id", "{{ $idInstitutionTable }}");
                let idFormModal = "#:id".replace(":id", "{{ $formModal }}");

                BasicDataTable.initializeDataTable({
                    storeUrl: "{{ route('admin.institution.store') }}",
                    editUrl: "{{ route('admin.institution.edit', ':id') }}",
                    updateUrl: "{{ route('admin.institution.update', ':id') }}",
                    idTable: $(idTable),
                    idFormModal: $(idFormModal),
                    headerActionsPosition: 5,
                    requestServer: function(data) {
                        $(idFormModal).find('input[name="_method"]').val('PUT')
                        $('input[name="name"]').val(data.name)
                        $('input[name="bank_account_number"]').val(data.bank_account_number)
                        $('input[name="bank_account_holder_name"]').val(data.bank_account_holder_name)
                        $('input[name="clone_bank_account_number"]').val(data.bank_account_number)
                        $('input[name="clone_bank_account_holder_name"]').val(data.bank_account_holder_name)
                        $('input[name="institution"]').val(data.institution)
                        $('input[name="email"]').val(data.email)
                        $('input[name="admin_name"]').val(data.user.name)
                        $('input[name="admin_username"]').val(data.user.username)
                        $('input[name="admin_email"]').val(data.user.email)
                        $('input[name="admin_phone"]').val(data.user.phone)
                        $('input[name="old_logo_file"]').val(data.logo)
                        $('input[name="province_hide"]').val(data.province)
                        $('input[name="regency_hide"]').val(data.regency)
                        $('input[name="district_hide"]').val(data.district)
                        $('input[name="sub_district_hide"]').val(data.sub_district)

                        selectOptionByText($('select[name="province"]'), $('input[name="province_hide"]')
                            .val())

                        if (data.province != null && data.regency != null && data.district != null && data
                            .sub_district !=
                            null) {
                            fetchAndPopulateDropdown(
                                '#province',
                                '#regency',
                                `{{ route('ajax.location.regencies', ':id') }}`.replace(':id', $(
                                    '#province').val()),
                                'Pilih Kabupaten'
                            ).then((result) => {
                                selectOptionByText($('select[name="regency"]'),
                                    $('input[name="regency_hide"]').val())
                                fetchAndPopulateDropdown(
                                    '#regency',
                                    '#district',
                                    `{{ route('ajax.location.districts', ':id') }}`.replace(
                                        ':id', $(
                                            '#regency')
                                        .val()),
                                    'Pilih Kecamatan'
                                ).then((result) => {
                                    selectOptionByText($('select[name="district"]'), $(
                                        'input[name="district_hide"]').val())
                                    fetchAndPopulateDropdown(
                                        '#district',
                                        '#sub_district',
                                        `{{ route('ajax.location.sub-districts', ':id') }}`
                                        .replace(
                                            ':id',
                                            $('#district').val()),
                                        'Pilih Kelurahan'
                                    ).then((result) => {
                                        selectOptionByText($(
                                                'select[name="sub_district"]'),
                                            $(
                                                'input[name="sub_district_hide"]'
                                            ).val())
                                    })
                                })
                            })
                        }



                        if (data.logo != null) {
                            $('.img-preview').css('display', 'block')
                            $('.img-preview').attr('src', '{{ Storage::url('') }}' +
                                data.logo)
                        }
                    },
                });

                $(idFormModal).on('hidden.bs.modal', function() {
                    $(this).find('.img-preview').attr('src', null) // Reset the form method if needed
                });

                $.ajax({
                    url: "{{ route('ajax.location.provinces') }}",
                    type: 'GET',
                    dataType: 'json',
                    success: function(response) {
                        let options = [`<option value="0" disabled selected>Pilih Provinsi</option>`]
                        $.each(response, function(index, value) {
                            options.push(
                                `<option value="${value.id}">${value.name}</option>`
                            )
                        })
                        $('#province').html(options)

                        if (false) {
                            selectOptionByText($('select[name="province"]'), $(
                                'input[name="province_hide"]').val())
                            fetchAndPopulateDropdown(
                                '#province',
                                '#regency',
                                `{{ route('api.location.regencies', ':id') }}`.replace(':id', $(
                                    '#province').val()),
                                'Pilih Kabupaten'
                            ).then((result) => {
                                selectOptionByText($('select[name="regency"]'),
                                    $('input[name="regency_hide"]').val())
                                fetchAndPopulateDropdown(
                                    '#regency',
                                    '#district',
                                    `{{ route('ajax.location.districts', ':id') }}`.replace(
                                        ':id', $('#regency')
                                        .val()),
                                    'Pilih Kecamatan'
                                ).then((result) => {
                                    selectOptionByText($('select[name="district"]'), $(
                                        'input[name="district_hide"]').val())
                                    fetchAndPopulateDropdown(
                                        '#district',
                                        '#sub_district',
                                        `{{ route('ajax.location.sub-districts', ':id') }}`
                                        .replace(
                                            ':id',
                                            $('#district').val()),
                                        'Pilih Kelurahan'
                                    ).then((result) => {
                                        selectOptionByText($(
                                                'select[name="sub_district"]'),
                                            $(
                                                'input[name="sub_district_hide"]'
                                            ).val())
                                    })
                                })
                            })
                        }
                    }
                })

                $('#province').on('change', function() {
                    const selectedProvinceId = this.value;
                    $('input[name="province_hide"]').val($(this).find('option:selected').text())
                    fetchAndPopulateDropdown(
                        '#province',
                        '#regency',
                        `{{ route('ajax.location.regencies', ':id') }}`.replace(':id', selectedProvinceId),
                        'Pilih Kabupaten'
                    );

                    populateDropdown('#district', [], 'Pilih Kecamatan');
                    populateDropdown('#sub_district', [], 'Pilih Kelurahan');
                });

                $('#regency').on('change', function() {
                    const selectedRegencyId = this.value;
                    $('input[name="regency_hide"]').val($(this).find('option:selected').text())
                    fetchAndPopulateDropdown(
                        '#regency',
                        '#district',
                        `{{ route('ajax.location.districts', ':id') }}`.replace(':id', selectedRegencyId),
                        'Pilih Kecamatan'
                    );

                    populateDropdown('#sub_district', [], 'Pilih Kelurahan');
                });

                $('#district').on('change', function() {
                    const selectedDistrictId = this.value;
                    $('input[name="district_hide"]').val($(this).find('option:selected').text())
                    fetchAndPopulateDropdown(
                        '#district',
                        '#sub_district',
                        `{{ route('ajax.location.sub-districts', ':id') }}`.replace(':id',
                            selectedDistrictId),
                        'Pilih Kelurahan'
                    );
                });

                $('#sub_district').on('change', function() {
                    $('input[name="sub_district_hide"]').val($(this).find('option:selected').text())
                });

                $('#formInstitution').on('submit', function(e) {
                    e.preventDefault()
                    $.ajax({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: $(this).attr('action'),
                        type: 'POST',
                        dataType: 'json',
                        data: $(this).serialize(),
                        beforeSend: function() {
                            $('html').block({
                                message: '<div class="spinner-border text-primary" role="status"></div>',
                                timeout: 0,
                                css: {
                                    backgroundColor: "transparent",
                                    border: "0"
                                },
                                overlayCSS: {
                                    backgroundColor: "#000",
                                    opacity: 0.25
                                }
                            })
                        },
                        success: function(response) {
                            $('#{{ $formModal }}').modal('hide')
                            Swal.fire({
                                icon: !response.success ? 'error' : 'success',
                                title: response.description,
                                didClose: (result) => {
                                    location.reload()
                                }
                            });
                        },
                        error: function(xhr, status, error) {
                            console.log(xhr);
                            console.log(status);
                            console.log(error);
                            if (xhr.status == 422) {
                                const errors = xhr.responseJSON.errors
                                Object.keys(errors).forEach(key => {
                                    const errorMessage = errors[key][0]
                                    const inputField = $("#" + key)
                                    const feedbackElement = inputField.next(
                                        ".invalid-feedback")

                                    // Menampilkan pesan error ke dalam elemen "invalid-feedback"
                                    feedbackElement.text(errorMessage)
                                    $('.invalid-feedback').text(errorMessage)

                                    // Menambahkan kelas "is-invalid" pada elemen input yang tidak valid
                                    inputField.addClass("is-invalid")
                                });
                            } else {
                                $("#{{ $formModal }}").modal('hide')
                                $("#modal-loading").modal('show')

                                setTimeout(function() {
                                    $("#modal-loading").modal('hide')
                                    $("#modal-error").modal('show')
                                }, 2000);
                            }
                        },
                        complete: function() {
                            // This function will run when the request (success or error) is complete
                            // You can unblock the page here
                            $('html').unblock();
                        }
                    });
                });

                $('#reloadTable').on('click', function() {
                    dt_public_table.ajax.reload(null, false)
                })
            });
        </script>
    @endpush
@endsection
