@extends('layouts.auth')

@section('title')
    {{ $title }}
@endsection

@section('content')
    <form id="formAuthentication" action="{{ route('auth.login', $role) }}" method="POST">
        @csrf
        <h3>Ahlan wa Sahlan!</h3>
        <div class="mb-3">
            <label for="username" class="form-label">Username</label>
            <input type="text" class="form-control @error('username') is-invalid @enderror" id="username" name="username"
                placeholder="Enter your username" value="{{ old('username') }}" required />
            @error('username')
                <div class="fv-plugins-message-container invalid-feedback">
                    {{ $message }}
                </div>
            @enderror
        </div>
        <div class="mb-3 form-password-toggle">
            <div class="d-flex justify-content-between">
                <label class="form-label" for="password">Password</label>
            </div>
            <div class="input-group input-group-merge">
                <input type="password" id="password" class="form-control @error('password') is-invalid @enderror"
                    name="password" placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                    aria-describedby="password" required />
                <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                @error('password')
                    <div class="fv-plugins-message-container invalid-feedback">
                        {{ $message }}
                    </div>
                @enderror
            </div>
        </div>

        <div class="mb-3">
            <button class="btn btn-primary d-grid w-100" type="submit">Login</button>
            @if (!request()->routeIs('login'))
                <a href="/" class="btn btn-outline-primary w-100 mt-4"><span> &#8592; </span>back</a>
            @endif
        </div>
    </form>
@endsection
