<div class="py-3">
    <!-- Mini Stats Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card mini-stats">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="text-muted mb-1">Total Pendapatan</h6>
                            <h4 class="mb-0">Rp {{ number_format($totalIncome, 0, ',', '.') }}</h4>
                        </div>
                        <div class="mini-stat-icon">
                            <i class="bx bx-money text-success"></i>
                        </div>
                    </div>
                    <p class="text-muted mt-2 mb-0">
                        @if($percentageChange > 0)
                            <span class="text-success me-1">
                                <i class="bx bx-up-arrow-alt"></i> {{ number_format($percentageChange, 1) }}%
                            </span>
                        @elseif($percentageChange < 0)
                            <span class="text-danger me-1">
                                <i class="bx bx-down-arrow-alt"></i> {{ number_format(abs($percentageChange), 1) }}%
                            </span>
                        @else
                            <span class="text-warning me-1">
                                <i class="bx bx-minus"></i> 0%
                            </span>
                        @endif
                        <span>Dari bulan lalu</span>
                    </p>
                </div>
            </div>
        </div>
        <!-- Tambahkan card mini stats lainnya disini -->
    </div>

    <!-- Main Chart -->
    <div class="card">
        <div class="card-header border-0 d-flex justify-content-between align-items-center">
            <h5 class="card-title mb-0">Statistik Keuangan</h5>
            <div class="d-flex gap-2">
                <button class="btn btn-soft-primary btn-sm" id="oneMonth">1M</button>
                <button class="btn btn-soft-primary btn-sm" id="sixMonths">6M</button>
                <button class="btn btn-soft-primary btn-sm active" id="oneYear">1Y</button>
                <button class="btn btn-soft-primary btn-sm" id="all">ALL</button>
            </div>
        </div>
        <div class="card-body">
            <div id="chart" data-aos="zoom-out" data-aos-duration="500"></div>
        </div>
    </div>
</div>

@push('css')
<style>
/* Import Google Font */
@import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap');

.card {
    background: rgba(255, 255, 255, 0.9);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.15);
    border-radius: 15px;
    transition: all 0.3s ease;
}

.card-title {
    font-family: 'Poppins', sans-serif;
    font-weight: 600;
    letter-spacing: 0.5px;
    background: linear-gradient(45deg, #556ee6, #00E396);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    margin-bottom: 0;
}

.text-muted {
    font-family: 'Poppins', sans-serif;
    font-weight: 500;
}

.mini-stats h4 {
    font-family: 'Poppins', sans-serif;
    font-weight: 700;
    letter-spacing: 0.5px;
}

.mini-stats h6 {
    font-family: 'Poppins', sans-serif;
    font-weight: 500;
    text-transform: uppercase;
    letter-spacing: 1px;
    font-size: 0.8rem;
}

.card:hover {
    transform: translateY(-5px);
    box-shadow: 0 12px 40px 0 rgba(31, 38, 135, 0.25);
}

.mini-stats {
    overflow: hidden;
}

.mini-stat-icon {
    font-size: 24px;
    background: rgba(0, 227, 150, 0.2);
    padding: 15px;
    border-radius: 50%;
}

.btn-soft-primary {
    font-family: 'Poppins', sans-serif;
    font-weight: 500;
    background-color: rgba(85, 110, 230, 0.1);
    border: 1px solid rgba(85, 110, 230, 0.1);
    color: #556ee6;
}

.btn-soft-primary.active {
    background-color: #556ee6;
    color: white;
}

.btn-soft-primary:hover {
    background-color: #556ee6;
    color: white;
}
</style>
@endpush
