@extends('layouts.dashboard')

@section('title')
    Tagihan
@endsection

@section('content')
    <div class="row">
        <h4 class="py-3 mb-4">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="/">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active">Tagihan</li>
                </ol>
            </nav>
        </h4>
        <div class="col">
            <div class="card">
                <div class="card-body">
                    <x-basic-data-table :id="$idBillTable" :routeDelete="route('institution.bill.destroy')" :headers="$headers" :rows="$rows" />
                </div>
            </div>
        </div>
    </div>

    @push('show-modal')
        @php
            $formModal = 'formBillModal';
        @endphp
        {{-- FORM MODAL --}}
        <x-show-modal :id="$formModal">
            <div class="modal-header">
                <h5 class="modal-title" id="modalToggleLabel">
                    <div id="modalToggleLabel2"></div>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('institution.bill.store') }}" method="POST">
                    @csrf
                    @method('POST')
                    <div class="row">
                        @field([
                            'label' => 'Nama Tagihan',
                            'name' => 'name',
                            'placeholder' => 'Syahriyah',
                            'type' => 'text',
                        ])
                        @field([
                            'label' => 'Tahun Pelajaran',
                            'name' => 'school_year',
                            'type' => 'select',
                            'options' => $school_years->map(function ($school_year) {
                                    return '<option value="' . $school_year->id . '">' . $school_year->start_year . '-' . $school_year->end_year . '</option>';
                                })->join(' '),
                        ])
                        @field([
                            'label' => 'Jenis Tagihan',
                            'name' => 'category',
                            'type' => 'select',
                            'options' => $bill_categories->map(function ($bill_category) {
                                    return '<option value="' . $bill_category->id . '">' . $bill_category->name . '</option>';
                                })->join(' '),
                        ])
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                    Batal
                </button>
                <button type="submit" class="btn btn-primary">
                    Simpan
                </button>
            </div>
            </form>
        </x-show-modal>
    @endpush
    @push('js')
        <!-- Include Utils -->
        <script src="{{ asset('assets/js/utils.js') }}"></script>
        <!-- Setup DataTable -->
        <script src="{{ asset('assets/js/basic-table-ajax.js') }}"></script>
        <script>
            $(document).ready(function() {
                let idTable = "#:id".replace(":id", "{{ $idBillTable }}");
                let idFormModal = "#:id".replace(":id", "{{ $formModal }}");

                BasicDataTable.initializeDataTable({
                    storeUrl: "{{ route('institution.bill.store') }}",
                    editUrl: "{{ route('institution.bill.edit', ':id') }}",
                    updateUrl: "{{ route('institution.bill.update', ':id') }}",
                    showUrl: {
                        add: "{{ route('institution.bill.show', ':id') }}",
                        show: "{{ route('institution.bill-detail.index', ':id') }}",
                    },
                    idTable: $('#' + '{{ $idBillTable }}'),
                    idFormModal: $('#' + '{{ $formModal }}'),
                    headerActionsPosition: 4,
                    requestServer: function(data) {
                        $('#' + '{{ $formModal }}').find('input[name="_method"]').val('PUT')
                        $('input[name="name"]').val(data.name)
                        $('select[name="school_year"]').val(data.school_year_id).change()
                        $('select[name="category"]').val(data.bill_category_id).change()
                    },
                });
            });
        </script>
    @endpush
@endsection
