@extends('layouts.dashboard')

@section('title')
    Detail Tagihan
@endsection

@section('content')
    @push('css')
        <style>
            .input-group-text {
                /* width: 20%; */
                width: 7rem;
            }
        </style>
        <link rel="stylesheet" href="{{ asset('assets/vendor/libs/dataTables/dataTables.bootstrap5.min.css') }}">
    @endpush
    <div class="row">
        <h4 class="fw-bold py-3 mb-4">
            <span class="text-muted fw-light"><a href="/">Dashboard</a>
                /
                <a href="{{ route('institution.bill') }}">Tagihan</a> / </span> Detail Tagihan
        </h4>
        <div class="col">
            <div class="card">
                <div class="card-header">
                    <h5><span class="skeleton">Tambah Tagihan : <strong>{{ $bill->name }}</strong></span></h5>
                </div>
                @if ($bill->bill_category->name == 'Bulanan')
                    <div class="card-body">

                        <form id="formMonth" method="POST">
                            <div class="row">
                                <div class="col-6 mb-2">
                                    <h5>{{ $bill->school_year->start_year }}</h5>
                                    <div class="input-group input-group-lg mb-2">
                                        <span class="input-group-text" id="nominal-juli">
                                            Juli
                                        </span>
                                        <input type="text" class="form-control" name="july" id="july"
                                            placeholder="750.000" aria-describedby="floatingInputHelp"
                                            oninput="formatNumber(this)" value="{{ $months['start']['july'] }}" />
                                        <div class="fv-plugins-message-container invalid-feedback">

                                        </div>
                                    </div>
                                    <div class="input-group input-group-lg mb-2">
                                        <span class="input-group-text" id="nominal-agustus">
                                            Agustus
                                        </span>
                                        <input type="text" class="form-control" name="august" id="august"
                                            placeholder="750.000" aria-describedby="floatingInputHelp"
                                            oninput="formatNumber(this)" value="{{ $months['start']['august'] }}" />
                                        <div class="fv-plugins-message-container invalid-feedback">

                                        </div>
                                    </div>
                                    <div class="input-group input-group-lg mb-2">
                                        <span class="input-group-text" id="nominal-september">
                                            September
                                        </span>
                                        <input type="text" class="form-control" name="september" id="september"
                                            placeholder="750.000" aria-describedby="floatingInputHelp"
                                            oninput="formatNumber(this)" value="{{ $months['start']['september'] }}" />
                                        <div class="fv-plugins-message-container invalid-feedback">

                                        </div>
                                    </div>
                                    <div class="input-group input-group-lg mb-2">
                                        <span class="input-group-text" id="nominal-oktober">
                                            Oktober
                                        </span>
                                        <input type="text" class="form-control" name="october" id="october"
                                            placeholder="750.000" aria-describedby="floatingInputHelp"
                                            oninput="formatNumber(this)" value="{{ $months['start']['october'] }}" />
                                        <div class="fv-plugins-message-container invalid-feedback">

                                        </div>
                                    </div>
                                    <div class="input-group input-group-lg mb-2">
                                        <span class="input-group-text" id="nominal-november">
                                            November
                                        </span>
                                        <input type="text" class="form-control" name="november" id="november"
                                            placeholder="750.000" aria-describedby="floatingInputHelp"
                                            oninput="formatNumber(this)" value="{{ $months['start']['november'] }}" />
                                        <div class="fv-plugins-message-container invalid-feedback">

                                        </div>
                                    </div>
                                    <div class="input-group input-group-lg mb-2">
                                        <span class="input-group-text" id="nominal-desember">Desember</span>
                                        <input type="text" class="form-control" name="december" id="december"
                                            placeholder="750.000" aria-describedby="floatingInputHelp"
                                            oninput="formatNumber(this)" value="{{ $months['start']['december'] }}" />
                                        <div class="fv-plugins-message-container invalid-feedback">

                                        </div>
                                    </div>
                                </div>
                                <div class="col-6 mb-2">
                                    <h5>{{ $bill->school_year->end_year }}</h5>
                                    <div class="input-group input-group-lg mb-2">
                                        <span class="input-group-text" id="nominal-addon13">Januari</span>
                                        <input type="text" class="form-control" name="january" id="january"
                                            placeholder="750.000" aria-describedby="floatingInputHelp"
                                            oninput="formatNumber(this)" value="{{ $months['end']['january'] }}" />
                                        <div class="fv-plugins-message-container invalid-feedback">

                                        </div>
                                    </div>
                                    <div class="input-group input-group-lg mb-2">
                                        <span class="input-group-text" id="nominal-addon13">Februari</span>
                                        <input type="text" class="form-control" name="february" id="february"
                                            placeholder="750.000" aria-describedby="floatingInputHelp"
                                            oninput="formatNumber(this)" value="{{ $months['end']['february'] }}" />
                                        <div class="fv-plugins-message-container invalid-feedback">

                                        </div>
                                    </div>
                                    <div class="input-group input-group-lg mb-2">
                                        <span class="input-group-text" id="nominal-addon13">Maret</span>
                                        <input type="text" class="form-control" name="march" id="march"
                                            placeholder="750.000" aria-describedby="floatingInputHelp"
                                            oninput="formatNumber(this)" value="{{ $months['end']['march'] }}" />
                                        <div class="fv-plugins-message-container invalid-feedback">

                                        </div>
                                    </div>
                                    <div class="input-group input-group-lg mb-2">
                                        <span class="input-group-text" id="nominal-addon13">April</span>
                                        <input type="text" class="form-control" name="april" id="april"
                                            placeholder="750.000" aria-describedby="floatingInputHelp"
                                            oninput="formatNumber(this)" value="{{ $months['end']['april'] }}" />
                                        <div class="fv-plugins-message-container invalid-feedback">
                                        </div>
                                    </div>
                                    <div class="input-group input-group-lg mb-2">
                                        <span class="input-group-text" id="nominal-addon13">Mei</span>
                                        <input type="text" class="form-control" name="may" id="may"
                                            placeholder="750.000" aria-describedby="floatingInputHelp"
                                            oninput="formatNumber(this)" value="{{ $months['end']['may'] }}" />
                                        <div class="fv-plugins-message-container invalid-feedback">

                                        </div>
                                    </div>
                                    <div class="input-group input-group-lg mb-2">
                                        <span class="input-group-text" id="nominal-addon13">Juni</span>
                                        <input type="text" class="form-control" name="june" id="june"
                                            placeholder="750.000" aria-describedby="floatingInputHelp"
                                            oninput="formatNumber(this)" value="{{ $months['end']['june'] }}" />
                                        <div class="fv-plugins-message-container invalid-feedback">

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>

                    </div>

                    <div class="card-body" style="margin-top: -20px">
                        <div class="row">
                            <div class="col-lg-6 col-md-12 col-12 mb-2">
                                <div class="form-floating">
                                    <select name="" id="application" class="form-control">
                                        <option value="semua">
                                            Semua</option>
                                        <option value="jenjang">
                                            Jenjang
                                        </option>
                                        <option value="angkatan">
                                            Angkatan
                                        </option>
                                        <option value="kelas">
                                            Kelas
                                        </option>
                                        <option value="santri">
                                            Santri
                                        </option>
                                    </select>
                                    <label for="floatingInput">Aplikasikan ke-</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body" style="margin-top: -20px">
                        <div class="row">
                            <div class="col" id="list-table">
                                @csrf
                                @method('POST')
                                <form action="" method="POST" id="checklist-form">
                                    <table class="table p-2" id="edulevel-table" style="width: 100%; display: none;">
                                        <thead>
                                            <tr>
                                                <th width="16px">
                                                    <input type="checkbox"
                                                        class="dt-checkboxes head-edulevel-cb form-check-input"
                                                        style="height: 16px; width: 16px;" name="ids[]">
                                                </th>
                                                <th>Nama Jenjang</th>
                                                <th>Lembaga</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                    <table class="table p-2" id="batch-table" style="width: 100%; display: none;">
                                        <thead>
                                            <tr>
                                                <th width="16px">
                                                    <input type="checkbox"
                                                        class="dt-checkboxes head-batch-cb form-check-input"
                                                        style="height: 16px; width: 16px;" name="ids[]">
                                                </th>
                                                <th>Nama Angkatan</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>

                                    <table class="table p-2" id="class-table" style="width: 100%; display: none;">
                                        <thead>
                                            <tr>
                                                <th width="16px">
                                                    <input type="checkbox"
                                                        class="dt-checkboxes head-class-cb form-check-input"
                                                        style="height: 16px; width: 16px;" name="ids[]">
                                                </th>
                                                <th>Nama Kelas</th>
                                                <th>Angkatan</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>

                                    <table class="table p-2" id="student-table" style="width: 100%; display: none;">
                                        <thead>
                                            <tr>
                                                <th width="16px">
                                                    <input type="checkbox"
                                                        class="dt-checkboxes head-student-cb form-check-input"
                                                        style="height: 16px; width: 16px;" name="ids[]">
                                                </th>
                                                <th>Nama Santri</th>
                                                <th>Kelas</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </form>

                            </div>
                        </div>
                    </div>
                @else
                    <div class="card-body">

                        <div class="row">
                            <div class="col-6 mb-2">
                                <div class="form-floating">
                                    <input type="text" class="form-control" id="formAmount" placeholder="2.750.000"
                                        aria-describedby="floatingInputHelp" oninput="formatNumber(this)"
                                        value="{{ $amount }}" />
                                    <label for="floatingInput">Nominal</label>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-12 col-12 mb-2">
                                <div class="form-floating">
                                    <select name="" id="application" class="form-control">
                                        <option value="semua">
                                            Semua</option>
                                        <option value="jenjang">
                                            Jenjang
                                        </option>
                                        <option value="angkatan">
                                            Angkatan
                                        </option>
                                        <option value="kelas">
                                            Kelas
                                        </option>
                                        <option value="santri">
                                            Santri
                                        </option>
                                    </select>
                                    <label for="floatingInput">Aplikasikan ke-</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body" style="margin-top: -20px">
                        <div class="row">
                            <div class="col" id="list-table">
                                @csrf
                                @method('POST')
                                <form action="" method="POST" id="checklist-form">
                                    <table class="table p-2" id="edulevel-table" style="width: 100%; display: none;">
                                        <thead>
                                            <tr>
                                                <th width="16px">
                                                    <input type="checkbox"
                                                        class="dt-checkboxes head-edulevel-cb form-check-input"
                                                        style="height: 16px; width: 16px;" name="ids[]">
                                                </th>
                                                <th>Nama Jenjang</th>
                                                <th>Lembaga</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                    <table class="table p-2" id="batch-table" style="width: 100%; display: none;">
                                        <thead>
                                            <tr>
                                                <th width="16px">
                                                    <input type="checkbox"
                                                        class="dt-checkboxes head-batch-cb form-check-input"
                                                        style="height: 16px; width: 16px;" name="ids[]">
                                                </th>
                                                <th>Nama Angkatan</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>

                                    <table class="table p-2" id="class-table" style="width: 100%; display: none;">
                                        <thead>
                                            <tr>
                                                <th width="16px">
                                                    <input type="checkbox"
                                                        class="dt-checkboxes head-class-cb form-check-input"
                                                        style="height: 16px; width: 16px;" name="ids[]">
                                                </th>
                                                <th>Nama Kelas</th>
                                                <th>Angkatan</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>

                                    <table class="table p-2" id="student-table" style="width: 100%; display: none;">
                                        <thead>
                                            <tr>
                                                <th width="16px">
                                                    <input type="checkbox"
                                                        class="dt-checkboxes head-student-cb form-check-input"
                                                        style="height: 16px; width: 16px;" name="ids[]">
                                                </th>
                                                <th>Nama Santri</th>
                                                <th>Kelas</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </form>

                            </div>
                        </div>
                    </div>
                    <div class="card-body" style="margin-top: -20px">
                        <div class="row">
                            <div class="col">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 mt-5">
                                <div class="form-floating">
                                    <input type="date" class="form-control" id="formActivedAt"
                                        aria-describedby="floatingInputHelp"
                                        value="{{ $activatedAt ?? now()->format('Y-m-d') }}" required />
                                    <label for="floatingInput">Mulai Aktif</label>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
                <div class="card-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal"
                        data-bs-target="#modal-confirm">
                        Batal
                    </button>
                    <input type="submit" name="Simpan" class="btn btn-primary" value="Simpan" id="applicationSave">
                </div>
            </div>
        </div>
    </div>

    @push('show-modal')
        @php
            $idConfirm = 'modal-confirm';
        @endphp
        <x-show-modal :id="$idConfirm">
            <div class="modal-body">
                <div class="row justify-content-center align-items-center">
                    <img src="{{ asset('assets/img/illustrations/Shrug-bro.svg') }}" height="170" width="170"
                        style="object-fit: contain;">
                    <h3 class="text-center mt-2">Apakah kamu yakin ingin membatalkan tagihan?</h3>
                </div>
            </div>
            <div class="modal-footer justify-content-center">
                <input type="hidden" name="id-confirm">
                <button type="submit" class="btn btn-outline-secondary" data-bs-dismiss="modal" id="applicationCancel">
                    Oke
                </button>
                <button type="button" class="btn btn-primary" data-bs-dismiss="modal">
                    Cancel
                </button>
            </div>
        </x-show-modal>
    @endpush

    @push('js')
        <!-- include jQuery -->
        <script src="http://ajax.googleapis.com/ajax/libs/jquery/1/jquery.js"></script>
        <!-- include BlockUI -->
        <script src="https://cdn.jsdelivr.net/npm/jquery-blockui@2.7.0/jquery.blockUI.min.js"></script>
        <script src="{{ asset('assets/vendor/libs/dataTables/dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/vendor/libs/dataTables/dataTables.bootstrap5.min.js') }}"></script>
        <!-- Include Utils -->
        <script src="{{ asset('assets/js/utils.js') }}"></script>
        <script>
        let selectedIds = new Set();
            function createDataTable(tableTarget, route, columns) {
                tableTarget.show()
                // console.log(tableTarget.DataTable())
                return tableTarget.DataTable({
                    ajax: route,
                    // processing: true,
                    // serverSide: true,
                    columnDefs: columns,
                    dom: '<"row mx-1"<"col-sm-12 col-md-3" l><"col-sm-12 col-md-9"<"dt-action-buttons text-xl-end text-lg-start text-md-end text-start d-flex align-items-center justify-content-md-end justify-content-center flex-wrap me-1"<"me-3"f>B>>>t<"row mx-2"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
                    language: {
                        sLengthMenu: "_MENU_",
                        search: "Search",
                        searchPlaceholder: "Search.."
                    },
                });
            }
$(document).on('change', '.child-cb', function() {
        let value = $(this).val();
        if ($(this).is(':checked')) {
            selectedIds.add(value);
        } else {
            selectedIds.delete(value);
        }
    });
            $(document).ready(function() {
                $('.head-edulevel-cb').on('click', function() {
                    $('.child-cb').prop('checked', this.checked);
                });
                $('.head-student-cb').on('click', function() {
                    // $('.child-cb').prop('checked', this.checked);
                    let checkboxes = $('.child-cb');
            checkboxes.prop('checked', this.checked);
            checkboxes.each(function() {
                let value = $(this).val();
                if ($(this).is(':checked')) {
                    selectedIds.add(value);
                } else {
                    selectedIds.delete(value);
                }
            });
                });
                $('.head-batch-cb').on('click', function() {
                    $('.child-cb').prop('checked', this.checked);
                });
                $('.head-class-cb').on('click', function() {
                    $('.child-cb').prop('checked', this.checked);
                });

                $('.body').block({
                    centerX: true,
                    centerY: true,
                    css: {
                        width: '600px',
                        height: '300px',
                        border: '3px solid #FF9900',
                        backgroundColor: '#000',
                        color: '#fff',
                        padding: '25px'
                    }
                });
                $('#over').click(function() {
                    alert('clicked!');
                    $('.body').unblock();
                    return false;
                });
                $('#under').click(function() {
                    $('.body').unblock();
                    return false;
                });
                
               $('#student-table').on('draw.dt', function() {
            $('.dt-checkboxes').each(function() {
                let id = $(this).val();
                if (selectedIds.has(id)) {
                    $(this).prop('checked', true);
                }
            });
        });

                let dataTable = null;
                let tableTarget = null;
                let route = null;
                let columns = [];

                const commonColumns = [{
                    targets: 0,
                    orderable: false,
                    searchable: false,
                    checkboxes: true,
                    width: '16px',
                    render: function(data, type, full, meta) {
                        return `<input type="checkbox" class="dt-checkboxes form-check-input child-cb"
                style="height: 16px; width: 16px;" name="ids[]" value="${full.id}">`
                    }
                }];

                const commonColumnsForBatch = [{
                    targets: 0,
                    orderable: false,
                    searchable: false,
                    checkboxes: true,
                    width: '16px',
                    render: function(data, type, full, meta) {
                        return `<input type="checkbox" class="dt-checkboxes form-check-input child-cb"
                style="height: 16px; width: 16px;" name="ids[]" value="${full.batch}">`
                    }
                }]

                $('#application').change(function() {
                    const selectedValue = $(this).val();

                    if (dataTable && dataTable.destroy) {
                        dataTable.destroy();
                        tableTarget.hide();
                    }

                    switch (selectedValue) {
                        case 'jenjang':
                            $('#list-table').show()
                            route = '{{ route('ajax.edulevel', ':id') }}';
                            route = route.replace(':id', '{{ institution()->id }}')
                            tableTarget = $('#edulevel-table');
                            columns = [...commonColumns,
                                {
                                    targets: 1,
                                    responsivePriority: 2,
                                    render: function(data, type, full, meta) {
                                        return full.name;
                                    }
                                },
                                {
                                    targets: 2,
                                    responsivePriority: 2,
                                    render: function(data, type, full, meta) {
                                        return full.institution.name;
                                    }
                                }
                            ];
                            break;
                        case 'angkatan':
                            $('#list-table').show()
                            route = '{{ route('ajax.school-class.batch', ':id') }}';
                            route = route.replace(':id', '{{ institution()->id }}')
                            tableTarget = $('#batch-table');
                            columns = [...commonColumnsForBatch,
                                {
                                    targets: 1,
                                    responsivePriority: 2,
                                    render: function(data, type, full, meta) {
                                        return full.batch;
                                    }
                                }
                            ];
                            break;
                        case 'kelas':
                            $('#list-table').show()
                            route = '{{ route('ajax.school-class', ':id') }}';
                            route = route.replace(':id', '{{ institution()->id }}')
                            tableTarget = $('#class-table');
                            columns = [...commonColumns,
                                {
                                    targets: 1,
                                    responsivePriority: 2,
                                    render: function(data, type, full, meta) {
                                        return full.name;
                                    }
                                },
                                {
                                    targets: 2,
                                    responsivePriority: 2,
                                    render: function(data, type, full, meta) {
                                        return full.batch;
                                    }
                                }
                            ];
                            break;
                        case 'santri':
                            $('#list-table').show()
                            route = '{{ route('ajax.student', ':id') }}';
                            route = route.replace(':id', '{{ institution()->id }}')
                            tableTarget = $('#student-table');
                            columns = [...commonColumns,
                                {
                                    targets: 1,
                                    responsivePriority: 2,
                                    render: function(data, type, full, meta) {
                                        return full.name;
                                    }
                                },
                                {
                                    targets: 2,
                                    responsivePriority: 2,
                                    render: function(data, type, full, meta) {
                                        return full.school_class.name;
                                    }
                                }
                            ];
                            break;
                        default:
                            $('#list-table').hide()
                            break;
                    }

                    if (tableTarget) {
                        dataTable = createDataTable(tableTarget, route, columns)
                    }
                });

                $('#applicationSave').on('click', function() {
                    console.log("Sebelum dihapus duplikat:", selectedIds);
                  let idsArray = Array.from(selectedIds); 
                  let serializedIds = $.param({ ids: idsArray });
                  let formData = $('#checklist-form').serialize() + '&' + serializedIds;
                
                
                    const billCategory = '{{ $bill->bill_category->name }}';
                    if (!$('#formActivedAt').val() && (billCategory == 'Bebas' || billCategory ==
                            'BEBAS')) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Tanggal Aktif Harus Diisikan!',
                        });
                    } else if (!$('#formAmount').val() && (billCategory == 'Bebas' || billCategory ==
                            'BEBAS')) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Nominal Harus Diisikan!',
                        });
                    } else {
                        $.ajax({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                ids: formData,
                                category: '{{ $bill->bill_category->name }}',
                                formActivedAt: $('#formActivedAt').val() ?? null,
                                formAmount: $('#formAmount').val() ?? null,
                                formMonth: $("#formMonth").serialize() ?? null,
                                bill: '{{ $bill->id }}',
                                application: $('#application option:selected').val(),
                                school_year: '{{ $bill->school_year_id }}'
                            },
                            url: "{{ route('institution.bill-detail.store') }}",
                            beforeSend: function() {
                                $('html').block({
                                    message: '<div class="spinner-border text-primary" role="status"></div>',
                                    timeout: 0,
                                    css: {
                                        backgroundColor: "transparent",
                                        border: "0"
                                    },
                                    overlayCSS: {
                                        backgroundColor: "#000",
                                        opacity: 0.25
                                    }
                                })
                            },
                            success: function(response) {
                                console.log(response)
                                // location.reload()
                                if (response.success) {
                                    $('#application').val('semua').change()
                                }
                                Swal.fire({
                                    icon: !response.success ? 'error' : 'success',
                                    title: !response.succes ? response.error : response
                                        .description,
                                    didClose: (result) => {
                                        !response.success ? '' : window.location
                                            .replace(
                                                "{{ route('institution.bill') }}")
                                    }
                                });
                            },
                            error: function(xhr, status, error) {
                                if (xhr.status == 422) {
                                    // Mendapatkan pesan error dari respons JSON
                                    const errors = xhr.responseJSON.errors;
                                    console.log(errors)

                                    // Menghapus kelas "is-invalid" dari semua elemen input sebelum menampilkan pesan error
                                    $("input.is-invalid").removeClass("is-invalid");

                                    // Menghapus pesan error dari semua elemen "invalid-feedback"
                                    $(".invalid-feedback").text("");

                                    // Menampilkan pesan error ke dalam elemen "invalid-feedback" dan menambahkan kelas "is-invalid" pada elemen input yang tidak valid
                                    Object.keys(errors).forEach(key => {
                                        const errorMessage = errors[key][0];
                                        const inputField = $(`input[name='${key}']`);
                                        const feedbackElement = inputField.next(
                                            ".invalid-feedback");

                                        feedbackElement.text(errorMessage);
                                        inputField.addClass("is-invalid");
                                    });
                                } else {
                                    const errors = xhr.responseJSON.errors;
                                    console.log(errors)
                                    console.log(status)
                                    console.log(error)
                                    console.log(xhr)
                                }
                            },
                            complete: function() {
                                $('html').unblock();
                            }
                        })
                    }
                })

                $('#applicationCancel').on('click', function() {
                    $.ajax({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        type: 'DELETE',
                        dataType: 'json',
                        data: {
                            ids: $('#checklist-form').serialize(),
                            category: '{{ $bill->bill_category->name }}',
                            formActivedAt: $('#formActivedAt').val() ?? null,
                            formAmount: $('#formAmount').val() ?? null,
                            formMonth: $("#formMonth").serialize() ?? null,
                            bill: '{{ $bill->id }}',
                            application: $('#application option:selected').val(),
                            school_year: '{{ $bill->school_year_id }}'
                        },
                        url: "{{ route('institution.bill-detail.destroy') }}",
                        beforeSend: function() {
                            $('html').block({
                                message: '<div class="spinner-border text-primary" role="status"></div>',
                                timeout: 0,
                                css: {
                                    backgroundColor: "transparent",
                                    border: "0"
                                },
                                overlayCSS: {
                                    backgroundColor: "#000",
                                    opacity: 0.25
                                }
                            })
                        },
                        success: function(response) {
                            console.log(response)
                            // location.reload()
                            if (!response.success) {
                                Swal.mixin({
                                    showConfirmButton: true,
                                }).fire({
                                    icon: 'error',
                                    title: response.error,
                                })
                            } else {
                                $('#application').val('semua').change()
                                window.location.replace("{{ route('institution.bill') }}")
                            }
                        },
                        error: function(xhr, status, error) {
                            const errors = xhr.responseJSON.errors;
                            console.log(errors)
                            console.log(status)
                            console.log(error)
                            console.log(xhr)
                        },
                        complete: function() {
                            $('html').unblock();
                        }
                    })
                })
            })
        </script>
    @endpush
@endsection
