@extends('layouts.dashboard')

@section('title')
    Jenjang
@endsection

@section('content')
    <div class="row">
        <h4 class="py-3 mb-4">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="/">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active">Jenjang</li>
                </ol>
            </nav>
        </h4>
        <div class="col">
            @alertDataManage()
            <div class="card">
                <div class="card-body">
                    <x-basic-data-table :id="$idEduLevelTable" :routeDelete="route('institution.edulevel.destroy')" :headers="$headers" :rows="$rows" />
                </div>
            </div>
        </div>
    </div>
    @push('show-modal')
        @php
            $formModal = 'formClassModal';
        @endphp
        <x-show-modal :id="$formModal">
            <div class="modal-header">
                <h5 class="modal-title" id="modalToggleLabel">
                    <div id="modalToggleLabel2"></div>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('institution.edulevel.store') }}" method="POST">
                    @csrf
                    @method('POST')
                    <div class="row">
                        @field([
                            'label' => 'Nama Jenjang',
                            'name' => 'name',
                            'placeholder' => 'SMP/MTs',
                            'type' => 'text',
                        ])
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                    Batal
                </button>
                <button type="submit" class="btn btn-primary">
                    Simpan
                </button>
            </div>
            </form>
        </x-show-modal>
    @endpush
    @push('js')
        <!-- Include Utils -->
        <script src="{{ asset('assets/js/utils.js') }}"></script>
        <!-- Setup Custom DataTable Lib -->
        <script src="{{ asset('assets/js/basic-table-ajax.js') }}"></script>
        <script>
            $(document).ready(function() {
                let idTable = "#:id".replace(":id", "{{ $idEduLevelTable }}");
                let idFormModal = "#:id".replace(":id", "{{ $formModal }}")

                BasicDataTable.initializeDataTable({
                    storeUrl: "{{ route('institution.edulevel.store') }}",
                    editUrl: "{{ route('institution.edulevel.edit', ':id') }}",
                    updateUrl: "{{ route('institution.edulevel.update', ':id') }}",
                    idTable: $(idTable),
                    idFormModal: $(idFormModal),
                    headerActionsPosition: 3,
                    requestServer: function(data) {
                        $('#' + '{{ $formModal }}').find('input[name="_method"]').val('PUT')
                        $('input[name="name"]').val(data.name)
                    },
                })
            });
        </script>
    @endpush
@endsection
