@extends('layouts.dashboard')

@section('title')
    Tahun Ajaran
@endsection

@section('content')
    <div class="row">
        <h4 class="py-3 mb-4">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="/">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active">Tahun Ajaran</li>
                </ol>
            </nav>
        </h4>
        <div class="col">
            @alertDataManage()
            <div class="card">
                <div class="card-body">
                    <x-basic-data-table :id="$idSchoolYearTable" :routeDelete="route('institution.school-year.destroy')" :headers="$headers" :rows="$rows" />
                </div>
            </div>
        </div>
    </div>
    @push('show-modal')
        @php
            $formModal = 'formSchoolYearModal';
        @endphp
        <x-show-modal :id="$formModal">
            <div class="modal-header">
                <h5 class="modal-title" id="modalToggleLabel">
                    <div id="modalToggleLabel2"></div>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('institution.school-year.store') }}" method="POST">
                    @csrf
                    @method('POST')
                    <div class="row">
                        @field([
                            'label' => 'Tahun Mulai',
                            'name' => 'start_year',
                            'placeholder' => '2023',
                            'type' => 'text',
                        ])
                        @field([
                            'label' => 'Tahun Akhir',
                            'name' => 'end_year',
                            'placeholder' => '2024',
                            'type' => 'text',
                        ])
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                    Batal
                </button>
                <button type="submit" class="btn btn-primary">
                    Simpan
                </button>
            </div>
            </form>
        </x-show-modal>
    @endpush
    @push('js')
        <!-- Include Utils -->
        <script src="{{ asset('assets/js/utils.js') }}"></script>
        <!-- Setup Custom DataTable Lib -->
        <script src="{{ asset('assets/js/basic-table-ajax.js') }}"></script>
        <script>
            $(document).ready(function() {
                let idTable = "#:id".replace(":id", "{{ $idSchoolYearTable }}")
                let idFormModal = "#:id".replace(":id", "{{ $formModal }}")
                BasicDataTable.initializeDataTable({
                    storeUrl: "{{ route('institution.school-year.store') }}",
                    editUrl: "{{ route('institution.school-year.edit', ':id') }}",
                    updateUrl: "{{ route('institution.school-year.update', ':id') }}",
                    idTable: $(idTable),
                    idFormModal: $(idFormModal),
                    headerActionsPosition: 4,
                    requestServer: function(data) {
                        $(idFormModal).find('input[name="_method"]').val('PUT')
                        $('input[name="start_year"]').val(data.start_year)
                        $('input[name="end_year"]').val(data.end_year)
                    },
                });
            });
        </script>
    @endpush
@endsection
