<form action="{{ route('institution.student.update', $student->id) }}" method="POST">
    @method('PUT')
    @csrf
    <div class="row">
        {{-- Lembaga --}}
        <div class="col-6 mb-2">
            <div class="form-floating">
                <input type="text" class="form-control" id="institution_name" placeholder="Kode Edupay"
                    aria-describedby="floatingInputHelp"
                    value="{{ $student->school_class->educational_level->institution->institution }}" readonly />
                <label for="floatingInput">Kode Edupay</label>
            </div>
        </div>
        <div class="col-6 mb-2">
            <div class="form-floating">
                <input type="text" class="form-control" id="institution_id" placeholder="Nama Ma'had"
                    aria-describedby="floatingInputHelp"
                    value="{{ $student->school_class->educational_level->institution->name }}" readonly />
                <label for="floatingInput">Nama Ma'had</label>
            </div>
        </div>

        {{-- Kelas & Santri --}}
        <div class="col-6 mb-2">
            <div class="form-floating">
                <input type="text" class="form-control" name="nis" id="nis" placeholder="NIS"
                    aria-describedby="floatingInputHelp" value="{{ $student->nis }}" />
                <label for="floatingInput">NIS</label>
            </div>
        </div>
        <div class="col-6 mb-2">
            <div class="form-floating">
                <select name="school_class" class="form-control">
                    @foreach ($school_classes as $school_class)
                        <option value="{{ $school_class->id }}"
                            {{ $student->school_class_id == $school_class->id ? 'selected' : '' }}>
                            {{ $school_class->name }}</option>
                    @endforeach
                </select>
                <label for="floatingInput">Nama Kelas</label>
            </div>
        </div>

        {{-- Data Diri --}}
        <div class="col-6 mb-2">
            <div class="form-floating">
                <input type="text" class="form-control" name="name" id="name" placeholder="Nama Santri"
                    aria-describedby="floatingInputHelp" value="{{ $student->name }}" />
                <label for="floatingInput">Nama Santri</label>
            </div>
        </div>
        <div class="col-6 mb-2">
            <div class="form-floating">
                <input type="text" class="form-control" name="phone" id="phone" placeholder="No Telepon"
                    aria-describedby="floatingInputHelp" value="{{ $student->phone }}" />
                <label for="floatingInput">No Telepon</label>
            </div>
        </div>
        <div class="col-12 d-flex justify-content-end mt-4">
            <button class="btn btn-primary">Edit</button>
        </div>
    </div>
</form>
