<div class="table-responsive">
    <table class="table table-responsive p-2" id="{{ $id }}" style="width: 100%">
        <thead>
            <tr>
                <td width="2%">
                    <input type="checkbox" class="dt-checkboxes form-check-input head-cb" style="height: 16px; width: 16px;"
                        name="ids[]">
                </td>
                <th>#</th>
                <th>Nama</th>
                <th>Nominal</th>
                <th>{{ $status == 'BILLED' ? 'Aktif' : 'Lunas' }}</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($groupedBillDetails as $billId => $details)
                @php
                    $statusDetails = $details->firstWhere('status', $status);
                @endphp

                @if ($statusDetails)
                    @php
                        $totalAmount = $details->where('status', $status)->sum('amount');
                        $tableCount++;

                        $actived_at = $statusDetails->actived_at
                            ? ($details->where('status', $status)->count() > 1
                                ? '-'
                                : carbon()
                                    ->parse($statusDetails->actived_at)
                                    ->format('d M y'))
                            : '-';
                        $paid_at =
                            $details->where('status', $status)->count() > 1
                                ? '-'
                                : carbon()
                                    ->parse($statusDetails->paid_at)
                                    ->format('d M y');
                    @endphp
                    <tr>
                        <td width="2%">
                            <input type="checkbox" class="dt-checkboxes child-cb form-check-input"
                                style="height: 16px; width: 16px;" name="ids[]" value="{{ $statusDetails->id }}">
                        </td>
                        <td>{{ $tableCount }}</td>
                        <td>{{ $statusDetails->bill->name }}</td>
                        <td>Rp{{ number_format($totalAmount, 0, '.', '.') }}, -</td>
                        <td>
                            {{ $status != 'PAID' ? $actived_at : $paid_at }}
                        </td>
                        <td>
                            @if ($status != 'PAID')
                                <a href="{{ route('institution.student-bill.edit', [$statusDetails->student_id, $statusDetails->bill_id]) }}"
                                    class="btn btn-icon text-primary item-edit"
                                    data-student="{{ $statusDetails->student_id }}"
                                    data-bill="{{ $statusDetails->bill_id }}"><i class="bx bxs-edit bx-sm"></i></a>
                                <a href="javascript:;" class="btn btn-icon text-danger item-delete"
                                    data-delete="{{ $statusDetails->id }}" data-status="{{ $status }}"
                                    data-bs-toggle="modal" data-bs-target="#modal-confirm"><i
                                        class="bx bxs-trash bx-sm"></i></a>
                            @endif
                            {!! $details->where('status', $status)->count() > 1
                                ? '<a href="#" class="btn btn-icon text-info btn-show-details" data-bs-toggle="modal" data-bs-target="#billDetailsModal" data-id="' .
                                    $statusDetails->bill_id .
                                    '" data-status="' .
                                    $status .
                                    '" data-student="' .
                                    $statusDetails->student_id .
                                    '"><i class="bx bxs-show bx-sm"></i></a>'
                                : '' !!}
                            {!! $details->where('status', $status)->count() < 2 &&
                            $details->where('status', $status)->first()->bill->bill_category_id == 2 &&
                            $status != 'PAID'
                                ? '<a href="#" class="btn btn-sm btn-primary btn-show-cicil" data-bs-toggle="modal" data-bs-target="#billCicilModal" data-id="' .
                                    $statusDetails->bill_id .
                                    '" data-status="' .
                                    $status .
                                    '" data-student="' .
                                    $statusDetails->student_id .
                                    '">CICIL</a>'
                                : '' !!}
                        </td>
                    </tr>
                @endif
            @endforeach
        </tbody>
    </table>
</div>

@push('css')
<style>
    .table-responsive {
        overflow-x: auto;
    }
    
    #{{ $id }} th,
    #{{ $id }} td {
        white-space: nowrap;
    }

    #{{ $id }} th:first-child,
    #{{ $id }} td:first-child { min-width: 40px; }  /* Checkbox */
    #{{ $id }} th:nth-child(2),
    #{{ $id }} td:nth-child(2) { min-width: 50px; }  /* No */
    #{{ $id }} th:nth-child(3),
    #{{ $id }} td:nth-child(3) { min-width: 200px; } /* Nama */
    #{{ $id }} th:nth-child(4),
    #{{ $id }} td:nth-child(4) { min-width: 150px; } /* Nominal */
    #{{ $id }} th:nth-child(5),
    #{{ $id }} td:nth-child(5) { min-width: 120px; } /* Tanggal */
    #{{ $id }} th:last-child,
    #{{ $id }} td:last-child { min-width: 100px; } /* Actions */
</style>
@endpush
