@extends('layouts.dashboard')


@section('title')
Laporan Keuangan
@endsection

@push('css')
<link rel="stylesheet" href="{{ asset('assets/vendor/libs/dataTables/dataTables.bootstrap5.min.css') }}">
<style>
    .btn-full-width {
        width: 100%;
    }
</style>
@endpush
@section('content')
<div class="row">
    <h4 class="py-3 mb-4">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="/">Dashboard</a>
                </li>
                <li class="breadcrumb-item active">Keuangan</li>
            </ol>
        </nav>
    </h4>
    <div class="nav-align-top">
        <ul class="nav nav-pills mb-3" role="tablist">
            <li class="nav-item">
                <button type="button" class="nav-link active" role="tab" data-bs-toggle="tab"
                    data-bs-target="#navs-pills-top-edulevel" aria-controls="navs-pills-top-edulevel"
                    aria-selected="true">Harian</button>
            </li>
            <li class="nav-item">
                <button type="button" class="nav-link" role="tab" data-bs-toggle="tab"
                    data-bs-target="#navs-pills-top-class" aria-controls="navs-pills-top-class"
                    aria-selected="false">Bulanan</button>
            </li>
            <li class="nav-item">
                <button type="button" class="nav-link" role="tab" data-bs-toggle="tab"
                    data-bs-target="#navs-pills-top-batch" aria-controls="navs-pills-top-group"
                    aria-selected="false">Tagihan</button>
            </li>

        </ul>
        <div class="tab-content">
            <div class="tab-pane fade show active" id="navs-pills-top-edulevel" role="tabpanel">
                <div class="row">
                    <div class="col-lg-3 col-6">
                        <label for="" class="form-label">Tgl Awal</label>
                        <input type="date" class="form-control" name="tgl_awal" id="tgl_awal">
                    </div>
                    <div class="col-lg-3 col-6 mb-3">
                        <label for="" class="form-label">Tgl Akhir</label>
                        <input type="date" class="form-control" name="tgl_akhir" id="tgl_akhir">
                    </div>
                    <div class="col-lg-2 col-12">
                        <label for="" class="form-label">&nbsp;</label>
                        <button type="button" class="btn btn-primary btn-full-width" name="tampilkan"
                            id="tampilkan">Cari</button>
                    </div>

                    <div class="col-lg-4 col-12">
                        <div class="text-center mt-3">
                            <label for="" class="form-label">&nbsp;</label>
                            Total : <span id="total-terbayar" class="fs-4 text-primary">Rp. 0,-</span>
                        </div>
                    </div>

                </div>
                <hr class="hr">
                <div class="row mt-2">
                    <div class="col">

                        <div class="table-responsive tampil1" style="display: none">
                            <a href="javascript:;"
                                class="d-flex float-end btn btn-sm btn-primary mx-2 export-day">Download</a>
                            <table class="table table-sm table-bordered" id="harian">
                                <thead>
                                    <tr>
                                        <th width="5%">No</th>
                                        <th>Nama</th>
                                        <th>Deskripsi</th>
                                        <th>Nominal</th>
                                        <th>Tanggal</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>


            </div>
            <div class="tab-pane fade" id="navs-pills-top-class" role="tabpanel">
                <div class="row">
                    <div class="col-lg-3 col-6">
                        <label for="" class="form-label">Bulan</label>
                        <select name="bulan" id="bulan" class="form-control">
                            <?php
                                $bulan_sekarang = date('n');
                                $bulan_nama = [
                                    1 => 'Januari',
                                    2 => 'Februari',
                                    3 => 'Maret',
                                    4 => 'April',
                                    5 => 'Mei',
                                    6 => 'Juni',
                                    7 => 'Juli',
                                    8 => 'Agustus',
                                    9 => 'September',
                                    10 => 'Oktober',
                                    11 => 'November',
                                    12 => 'Desember',
                                ];
                                foreach ($bulan_nama as $angka => $nama) {
                                    $selected = $angka == $bulan_sekarang ? 'selected' : '';
                                    echo "<option value='$angka' $selected>$nama</option>";
                                }
                                ?>
                        </select>


                    </div>
                    <div class="col-lg-3 col-6 mb-3">
                        <label for="" class="form-label">Tahun Pelajaran</label>
                        <select name="tp" id="tp" class="form-control">
                            @foreach ($tp as $t)
                            <option value="{{ $t->id }}">{{ $t->start_year . '/' . $t->end_year }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-lg-2 col-12">
                        <label for="" class="form-label">&nbsp;</label>
                        <button type="button" class="btn btn-primary btn-full-width" name="tampilkan2"
                            id="tampilkan2">Cari</button>
                    </div>
                    <div class="col-lg-4 col-12">
                        <div class="text-center mt-3">
                            <label for="" class="form-label">&nbsp;</label>
                            Total : <span id="total-terbayar2" class="fs-4 text-primary">Rp. 0,-</span>
                        </div>

                    </div>
                </div>
                <hr class="hr">
                <div class="row mt-2">
                    <div class="col">
                        <div class="table-responsive tampil2" style="display: none">
                            <a href="javascript:;"
                                class="d-flex float-end btn btn-sm btn-primary mx-2 export-month">Download</a>
                            <table class="table table-sm table-bordered" id="bulanan">
                                <thead>
                                    <tr>
                                        <th width="5%">No</th>
                                        <th>Nama</th>
                                        <th>Deskripsi</th>
                                        <th>Nominal</th>
                                        <th>Tanggal</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="navs-pills-top-batch" role="tabpanel">
                <div class="row">
                    <div class="col-lg-3 col-12">
                        <label for="" class="form-label">Tagihan</label>
                        <select name="tagihan" id="tagihan" class="form-control" required>
                            <option value="">-- Pilih --</option>
                            @foreach ($billList as $bill)
                            <option value="{{ $bill->name }}">{{ $bill->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-lg-2 col-12">
                        <label for="" class="form-label">Status</label>
                        <select name="status" id="status" class="form-control">
                            <option value="">-- Pilih --</option>
                            <option value="ALL">ALL</option>
                            <option value="PAID">Lunas</option>
                            <option value="BILLED">Belum Lunas</option>
                        </select>
                    </div>
                    <!-- Tambahkan input tanggal aktif -->
                    <div class="col-lg-2 col-12">
                        <label for="" class="form-label">Mulai Dari</label>
                        <input type="date" class="form-control" name="tgl_aktif_awal" id="tgl_aktif_awal">
                    </div>
                    <div class="col-lg-2 col-12">
                        <label for="" class="form-label">Sampai Dengan</label>
                        <input type="date" class="form-control" name="tgl_aktif_akhir" id="tgl_aktif_akhir">
                    </div>
                    <div class="col-lg-2 col-12">
                        <label for="" class="form-label">&nbsp;</label>
                        <button type="submit" class="btn btn-primary btn-full-width" name="tampilkan3" id="tampilkan3">Cari</button>
                    </div>
                   
                </div>
                <hr class="hr">
                <div class="row mt-2">
                    <div class="col">
                        <div class="table-responsive tampil3" style="display: none">
                            <div class="d-flex float-end mb-2">
                <!-- Total di kanan -->
                <div class="d-flex gap-1">
                    <p class="mb-0">Total:</p> 
                    <span id="total-terbayar3" class="fs-4 text-primary">Rp. 0,-</span>
                </div>
            </div>
                           
                            <table class="table table-sm table-bordered" id="tagihan2">
                                <thead>
                                    <tr>
                                        <th width="5%">No</th>
                                        <th>Nama</th>
                                        <th>Deskripsi</th>
                                        <th>Nominal</th>
                                        <th>Tanggal Aktif</th>
                                        <th>Tanggal Bayar</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
@endsection
@push('js')
<script src="{{ asset('assets/vendor/libs/dataTables/dataTables.min.js') }}"></script>
<script src="{{ asset('assets/vendor/libs/dataTables/dataTables.bootstrap5.min.js') }}"></script>
<script src="https://cdn.datatables.net/buttons/1.7.1/js/dataTables.buttons.min.js"></script>

<script>
    function namaBulanIndonesia(bulan) {
            var bulanIndonesia = [
                "Januari", "Februari", "Maret", "April", "Mei", "Juni",
                "Juli", "Agustus", "September", "Oktober", "November", "Desember"
            ];

            if (bulan >= 1 && bulan <= 12) {
                return bulanIndonesia[bulan - 1];
            } else {
                return "";
            }
        }

        function formatRupiah(nominal) {
            return 'Rp. ' + nominal.toString().replace(/\./g, '').replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1.') + ',-';

        }
</script>
<script>
    $(document).ready(function() {
            var table = $('#harian').DataTable({
                autoWidth: false,
                paging: true,
                lengthChange: true,
                language: {
                    zeroRecords: "Silahkan Filter Data Terlebih Dahulu"
                }
            });
          
            $('#tampilkan').on('click', function() {
                var tableResponsive = document.querySelector(".tampil1");
                tableResponsive.style.setProperty('display', 'block', 'important');
                var tglAwal = $('#tgl_awal').val();
                var tglAkhir = $('#tgl_akhir').val();
                var institution = {{ institution()->id }};
                var downloadLink = "{{ route('institution.exportDay') }}?tgl_awal=" + tglAwal + "&tgl_akhir=" + tglAkhir + "&institution=" + institution;
            $('.export-day').attr('href', downloadLink);
                var total = 0;

                $.ajax({
                    url: '{{ route('institution.trxDay') }}',
                    type: 'GET',
                    dataType: 'json',
                    data: {
                        tgl_awal: tglAwal,
                        tgl_akhir: tglAkhir
                    },
                    success: function(data) {
                        if (data.length > 0) {
                            table.clear().draw();

                            $.each(data, function(index, item) {
                                var bulan = (item.bulan_aktif) ? item.bulan_aktif : '';
                                var bulanConvert = namaBulanIndonesia(bulan);
                                var rupiah = formatRupiah(item.nominal);
                                var row = [
                                    (index + 1),
                                    item.nama_santri,
                                    item.deskripsi + ' - ' + bulanConvert + ' ' +
                                    item.tahun_aktif,
                                    rupiah,
                                    item.tanggal
                                ];

                                total += parseFloat(item.nominal);
                                table.row.add(row).draw();
                            });

                            $('#total-terbayar').text(formatRupiah(total));


                           
                           
                        } else {
                            
                            $('#total-terbayar').text('Rp. 0');
                            tableResponsive.style.setProperty('display', 'none');
                                toastr.error("Data Tidak Ditemukan !");
                        }
                    },
                    error: function() {
                        toastr.error("Terjadi kesalahan dalam mengambil data !");
                    }
                });
            });
        });
        $(document).ready(function() {
            var table = $('#bulanan').DataTable({
                autoWidth: false,
                paging: true,
                lengthChange: true,
                language: {
                    zeroRecords: "Silahkan Filter Data Terlebih Dahulu"
                }
            });
          
            $('#tampilkan2').on('click', function() {
                var tableResponsive = document.querySelector(".tampil2");
                tableResponsive.style.setProperty('display', 'block', 'important');
                var bulan = $('#bulan').val();
                var tp = $('#tp').val();
                var institution = {{ institution()->id }};
                var downloadLink = "{{ route('institution.exportMonth') }}?tp=" + tp + "&bulan=" + bulan + "&institution=" + institution;
            $('.export-month').attr('href', downloadLink);
                var total = 0;

                $.ajax({
                    url: '{{ route('institution.trxMonth') }}',
                    type: 'GET',
                    dataType: 'json',
                    data: {
                        bulan: bulan,
                        tp: tp
                    },
                    success: function(data) {
                        if (data.length > 0) {
                            table.clear().draw();

                            $.each(data, function(index, item) {
                                var bulan = (item.bulan_aktif) ? item.bulan_aktif : '';
                                var bulanConvert = namaBulanIndonesia(bulan);
                                var rupiah = formatRupiah(item.nominal);
                                var row = [
                                    (index + 1),
                                    item.nama_santri,
                                    item.deskripsi + ' - ' + bulanConvert + ' ' +
                                    item.tahun_aktif,
                                    rupiah,
                                    item.tanggal
                                ];

                                total += parseFloat(item.nominal);
                                table.row.add(row).draw();
                            });

                            $('#total-terbayar2').text(formatRupiah(total));


                          
                          
                        } else {
                         
                            $('#total-terbayar2').text('Rp. 0');
                            tableResponsive.style.setProperty('display', 'none');
                                toastr.error("Data Tidak Ditemukan !");
                        }
                    },
                    error: function() {
                        toastr.error("Terjadi kesalahan dalam mengambil data !");
                    }
                });
            });
        });
        $(document).ready(function() {
            var table = $('#tagihan2').DataTable({
        dom: '<"row"<"col-md-6 d-flex align-items-center"f><"col-md-6 text-end"l>>rt<"row"<"col-md-12 text-start"p>>',
        autoWidth: false,
        paging: true,
        lengthChange: false,
        language: {
            zeroRecords: "Tidak ada data yang bisa ditampilkan"
        }
    });

    // Pindahkan tombol Download ke sebelah kanan Search
    let downloadButton = '<a href="javascript:;" class="btn btn-sm btn-primary ms-2 export-button">Download</a>';
    $('#tagihan2_filter').append(downloadButton).addClass('d-flex align-items-center gap-2');
           
          
            $('#tampilkan3').on('click', function() {
                var tableResponsive = document.querySelector(".tampil3");
                tableResponsive.style.setProperty('display', 'block', 'important');
                var tagihan = $('#tagihan').val();
                var status = $('#status').val();
                var tglAktifAwal = $('#tgl_aktif_awal').val();
                var tglAktifAkhir = $('#tgl_aktif_akhir').val();
                var institution = {{ institution()->id }};
                var downloadLink = "{{ route('institution.exportBill') }}?status=" + status + "&tagihan=" + tagihan + "&tgl_aktif_awal=" + tglAktifAwal + "&tgl_aktif_akhir=" + tglAktifAkhir + "&institution=" + institution;
                $('.export-button').attr('href', downloadLink);
                var total = 0;

                if(tagihan && status){
                    $.ajax({
                        url: '{{ route('institution.trxBill') }}',
                        type: 'GET',
                        dataType: 'json',
                        data: {
                            tagihan: tagihan,
                            status: status,
                            tgl_aktif_awal: tglAktifAwal,
                            tgl_aktif_akhir: tglAktifAkhir
                        },
                        success: function(data) {
                            if (data.length > 0) {
                                table.clear().draw();

                                $.each(data, function(index, item) {
                                    var bulan = (item.bulan_aktif) ? item.bulan_aktif : '';
                                    var bulanConvert = namaBulanIndonesia(bulan);
                                    var rupiah = formatRupiah(item.nominal);
                                    var tanggalAktif = item.actived_at ? new Date(item.actived_at).toLocaleDateString('id-ID') : '-';
                                    var tanggalBayar = item.status === 'BILLED' ? '-' : new Date(item.tanggal).toLocaleDateString('id-ID');
                                    var row = [
                                        (index + 1),
                                        item.nama_santri,
                                        item.deskripsi,
                                        rupiah,
                                        tanggalAktif,
                                        tanggalBayar
                                    ];

                                    total += parseFloat(item.nominal);
                                    table.row.add(row).draw();
                                });

                                $('#total-terbayar3').text(formatRupiah(total));
                            } else {
                                $('#total-terbayar3').text('Rp. 0');
                                tableResponsive.style.setProperty('display', 'none');
                                toastr.error("Data Tidak Ditemukan !");
                            }
                        },
                        error: function() {
                            toastr.error("Terjadi kesalahan dalam mengambil data !");
                        }
                    });
                } else {
                    toastr.error("Silahkan pilih tagihan dan status terlebih dahulu!");
                }
            });
        });
</script>


@endpush