@extends('layouts.dashboard')

@section('title')
    Asumsi Pendapatan
@endsection

@section('content')
    <div class="row">
        <h4 class="py-3 mb-4">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="/">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active">Asumsi Pendapatan</li>
                </ol>
            </nav>
        </h4>
        <div class="nav-align-top">
            <ul class="nav nav-pills mb-3" role="tablist">
                <li class="nav-item">
                    <button type="button" class="nav-link active" role="tab" data-bs-toggle="tab"
                        data-bs-target="#navs-pills-top-edulevel" aria-controls="navs-pills-top-edulevel"
                        aria-selected="true">Jenjang</button>
                </li>
                <li class="nav-item">
                    <button type="button" class="nav-link" role="tab" data-bs-toggle="tab"
                        data-bs-target="#navs-pills-top-class" aria-controls="navs-pills-top-class"
                        aria-selected="false">Kelas</button>
                </li>
                <li class="nav-item">
                    <button type="button" class="nav-link" role="tab" data-bs-toggle="tab"
                        data-bs-target="#navs-pills-top-batch" aria-controls="navs-pills-top-group"
                        aria-selected="false">Angkatan</button>
                </li>
                <li class="nav-item">
                    <button type="button" class="nav-link" role="tab" data-bs-toggle="tab"
                        data-bs-target="#navs-pills-top-bill" aria-controls="navs-pills-top-bill"
                        aria-selected="false">Tagihan</button>
                </li>
            </ul>
            <div class="tab-content">
                <div class="tab-pane fade show active" id="navs-pills-top-edulevel" role="tabpanel">
                    <div class="row">
                        <div class="col">

                            <h4 class="text-primary float-end">
                                Total : Rp. {{ number_format($eduLevelIncomeTotal[0]->total, 0, ',', '.') . ',-' }}
                            </h4>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col">
                            <x-basic-data-table-asumsi :id="$idEduLevelTable" :headers="$headers['eduLevelIncomeHeaders']" :rows="$rowsEduLevel" />
                            {{-- <div class="table-responsive">
                            <table class="table table-bordered table-sm" id="example">
                                <thead>
                                    <tr>
                                        <th width="5%">No</th>
                                        <th>Ma'had</th>
                                        <th>Jenjang</th>
                                        <th>Pendapatan</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php $no=1
                                    @endphp
                                    @foreach ($eduLevelIncome as $row)
                                    <tr>
                                        <td>{{$no++}}</td>
                                        <td>{{ $row->instiName }}</td>
                                        <td>{{ $row->name }}</td>
                                        <td>Rp. {{ number_format($row->total, 0, ',', '.') . ',-' }}</td>

                                    </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div> --}}
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade" id="navs-pills-top-class" role="tabpanel">
                    <div class="row">
                        <div class="col">

                            <h4 class="text-primary float-end">
                                Total : Rp. {{ number_format($classIncomeTotal[0]->total, 0, ',', '.') . ',-' }}
                            </h4>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col">
                            <x-basic-data-table-asumsi :id="$idClassTable" :headers="$headers['classIncomeHeaders']" :rows="$rowsClass" />
                            {{-- <div class="table-responsive">
                            <table class="table table-bordered table-sm" id="example">
                                <thead>
                                    <tr>
                                        <th width="5%">No</th>
                                        <th>Jenjang</th>
                                        <th>Kelas</th>
                                        <th>Pendapatan</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php $no=1
                                    @endphp
                                    @foreach ($classIncome as $row)
                                    <tr>
                                        <td>{{$no++}}</td>
                                        <td>{{ $row->jenjang }}</td>
                                        <td>{{ $row->name }}</td>
                                        <td>Rp. {{ number_format($row->total, 0, ',', '.') . ',-' }}</td>

                                    </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div> --}}
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade" id="navs-pills-top-batch" role="tabpanel">
                    <div class="row">
                        <div class="col">

                            <h4 class="text-primary float-end">
                                Total : Rp. {{ number_format($batchClassIncomeTotal[0]->total, 0, ',', '.') . ',-' }}
                            </h4>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col">
                            <x-basic-data-table-asumsi :id="$idBatchTable" :headers="$headers['batchIncomeHeaders']" :rows="$rowsBatch" />
                            {{-- <div class="table-responsive">
                            <table class="table table-bordered table-sm" id="example">
                                <thead>
                                    <tr>
                                        <th width="5%">No</th>
                                        <th>Jenjang</th>
                                        <th>Angkatan</th>
                                        <th>Pendapatan</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php $no=1
                                    @endphp
                                    @foreach ($batchClassIncome as $row)
                                    <tr>
                                        <td>{{$no++}}</td>
                                        <td>{{ $row->jenjang }}</td>
                                        <td>{{ $row->batch }}</td>
                                        <td>Rp. {{ number_format($row->total, 0, ',', '.') . ',-' }}</td>

                                    </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div> --}}
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade" id="navs-pills-top-bill" role="tabpanel">
                    <div class="row">
                        <div class="col">

                            <h4 class="text-primary float-end">
                                Total : Rp. {{ number_format($billIncomeTotal[0]->total, 0, ',', '.') . ',-' }}
                            </h4>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col">
                            <x-basic-data-table-asumsi :id="$idBillTable" :headers="$headers['billIncomeHeaders']" :rows="$rowsBill" />
                            {{-- <div class="table-responsive">
                            <table class="table table-bordered table-sm" id="example">
                                <thead>
                                    <tr>
                                        <th width="5%">No</th>
                                        <th>Nama Tagihan</th>
                                        <th>Pendapatan</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php $no=1
                                    @endphp
                                    @foreach ($billIncome as $row)
                                    <tr>
                                        <td>{{$no++}}</td>
                                        <td>{{ $row->name }}</td>
                                        <td>Rp. {{ number_format($row->total, 0, ',', '.') . ',-' }}</td>

                                    </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div> --}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @push('js')
        <!-- Include Utils -->
        <script src="{{ asset('assets/js/utils.js') }}"></script>
        <!-- Define Basic Table Config -->
        <script>
            const basic_table_config = {
                idTables: [
                    $('#' + '{{ $idEduLevelTable }}'),
                    $('#' + '{{ $idClassTable }}'),
                    $('#' + '{{ $idBatchTable }}'),
                    $('#' + '{{ $idBillTable }}')
                ]
            };
        </script>

        <!-- Setup DataTable -->
        <script src="{{ asset('assets/js/basic-table-asumsi.js') }}"></script>
    @endpush
@endsection
