<?php

use App\Http\Controllers\Ajax\BillAjaxController;
use App\Http\Controllers\Ajax\EduLevelAjaxController;
use App\Http\Controllers\Ajax\LocationAjaxController;
use App\Http\Controllers\Ajax\PaymentAjaxController;
use App\Http\Controllers\Ajax\SchoolClassAjaxController;
use App\Http\Controllers\Ajax\StudentAjaxController;
use App\Http\Controllers\Ajax\User\UserAjaxController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| AJAX Routes
|--------------------------------------------------------------------------
|
| Here is where you can register AJAX routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "ajax" middleware group. Enjoy building your API!
|
*/

Route::get('test', function () {
    return response()->json('hellow');
});
Route::get('/user/institution', [UserAjaxController::class, 'institution'])->name('user.institution');
Route::get('/user/admin', [UserAjaxController::class, 'admin'])->name('user.admin');
Route::get('/provinces', [LocationAjaxController::class, 'provinces'])->name('location.provinces');
Route::get('/provinces/{id}/regencies', [LocationAjaxController::class, 'regencies'])->name('location.regencies');
Route::get('/provinces/{id}/districts', [LocationAjaxController::class, 'districts'])->name('location.districts');
Route::get('/provinces/{id}/sub-districts', [LocationAjaxController::class, 'sub_districts'])->name('location.sub-districts');
Route::get('/bill-details/{id}-{student_id}/{status}/show', [BillAjaxController::class, 'show'])->name('bill.details');
Route::get('/students/{id}', [StudentAjaxController::class, 'index'])->name('student');
Route::get('/edu-levels/{id}', [EduLevelAjaxController::class, 'index'])->name('edulevel');
Route::get('/school-classes/{id}', [SchoolClassAjaxController::class, 'index'])->name('school-class');
Route::get('/school-classes/{id}/batch', [SchoolClassAjaxController::class, 'batch'])->name('school-class.batch');
Route::get('/payments', [PaymentAjaxController::class, 'index'])->name('payment');
Route::post('/payments/create', [PaymentAjaxController::class, 'store'])->name('payment.store');
Route::post('/bill-detail/cicil', [BillAjaxController::class, 'fetchCicil'])->name('bill.fetchCicil');
Route::post('/bill-detail/update/cicil', [BillAjaxController::class, 'storeSplitBill'])->name('bill.storeSplitBill');
