<?php

use App\Http\Controllers\Api\BillApiController;
use App\Http\Controllers\Api\BillDetailApiController;
use App\Http\Controllers\Api\EduLevelApiController;
use App\Http\Controllers\Api\FinanceApiController;
use App\Http\Controllers\Api\LocationApiController;
use App\Http\Controllers\Api\PaymentApiController;
use App\Http\Controllers\Api\SchoolClassApiController;
use App\Http\Controllers\Api\StudentApiController;
use App\Http\Controllers\Api\User\UserApiController;
use App\Http\Controllers\Api\InstitutionApiController;
use App\Http\Controllers\Api\SchoolYearApiController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::middleware('api_token')->group(function () {
    Route::get('/user/institution', [UserApiController::class, 'institution'])->name('api.user.institution');
    // Route::get('/institution', [InstitutionApiController::class, 'show'])->name('api.institution');
    Route::get('/institution', [InstitutionApiController::class, 'index'])->name('api.institution');
    // Route::get('/bill/{id}', [BillApiController::class, 'bill'])->name('api.bill');
    // Route::get('/billDetail/{id}', [BillDetailApiController::class, 'billDetail'])->name('api.billDetail');
    // Route::get('/students/{nis}', [StudentApiController::class, 'byNis'])->name('api.byNis');
    Route::get('/getBills/{institution}/{nis}', [InstitutionApiController::class, 'getInstitutionWithNis'])->name('api.getBills');
    Route::get('/getBillforSiri/{nis}', [InstitutionApiController::class, 'getBillforSiri'])->name('api.getBillsForSiri');
    Route::post('loginEdupay', [FinanceApiController::class, 'login'])->name('api.loginEdupay');
    Route::get('schoolYear', [SchoolYearApiController::class, 'index'])->name('api.schoolYear');
    Route::get('/bill/{institution}', [BillApiController::class, 'bill'])->name('api.bill');
    Route::post('/getTrxBill', [FinanceApiController::class, 'getTrxBill'])->name('api.getTrxBill');
    Route::post('/getTrxMonth', [FinanceApiController::class, 'getTrxMonth'])->name('api.getTrxMonth');
    Route::post('/getTrxDay', [FinanceApiController::class, 'getTrxDay'])->name('api.getTrxDay');
    // --

    Route::get('/user/admin', [UserApiController::class, 'admin'])->name('api.user.admin');
    Route::get('/provinces', [LocationApiController::class, 'provinces'])->name('api.location.provinces');
    Route::get('/provinces/{id}/regencies', [LocationApiController::class, 'regencies'])->name('api.location.regencies');
    Route::get('/provinces/{id}/districts', [LocationApiController::class, 'districts'])->name('api.location.districts');
    Route::get('/provinces/{id}/sub-districts', [LocationApiController::class, 'sub_districts'])->name('api.location.sub-districts');
    Route::get('/bill-details/{id}-{student_id}/{status}/show', [BillApiController::class, 'show'])->name('api.bill.details');
    Route::get('/students/{id}', [StudentApiController::class, 'index'])->name('api.student');
    Route::get('/edu-levels/{id}', [EduLevelApiController::class, 'index'])->name('api.edulevel');
    Route::get('/school-classes/{id}', [SchoolClassApiController::class, 'index'])->name('api.school-class');
    Route::get('/school-classes/{id}/batch', [SchoolClassApiController::class, 'batch'])->name('api.school-class.batch');
    Route::get('/payments', [PaymentApiController::class, 'index'])->name('api.payment');
    Route::post('/payments/create', [PaymentApiController::class, 'store'])->name('api.payment.store');
});
