<?php

use App\Http\Controllers\Auth\AuthController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Auth Routes
|--------------------------------------------------------------------------
|
| Here is where you can register auth routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Pak, login admin :
// edupay.bsn.co.id/auth/admin

// Login user :
// edupay.bsn.co.id/login

Route::get('/', [AuthController::class, 'index']);

Route::middleware('guest')->group(function () {
    Route::get('/auth/admin', [AuthController::class, 'adminLogin'])->name('loginAdmin');
    Route::get('/login', [AuthController::class, 'institutionLogin'])->name('login');

    Route::post('/auth/{role}/credential', [AuthController::class, 'store'])->name('auth.login');
});

Route::get('/logout', [AuthController::class, 'destroy'])->name('auth.logout');
Route::get('/logoutAdmin', [AuthController::class, 'destroyAdmin'])->name('auth.logoutAdmin');
