<?php

use App\Http\Controllers\Auth\PasswordController;
use App\Http\Controllers\Bill\BillController;
use App\Http\Controllers\Bill\BillDetailController;
use App\Http\Controllers\Config\ApiTokenController;
use App\Http\Controllers\Config\ConfigController;
use App\Http\Controllers\Dashboard\DashboardController;
use App\Http\Controllers\EduLevel\EduLevelController;
use App\Http\Controllers\Finance\FinanceController;
use App\Http\Controllers\Income\IncomeController;
use App\Http\Controllers\Institution\InstitutionController;
use App\Http\Controllers\NaikKelas\NaikKelasController;
use App\Http\Controllers\SchoolClass\SchoolClassController;
use App\Http\Controllers\SchoolYear\SchoolYearController;
use App\Http\Controllers\settlement\SettlementController;
use App\Http\Controllers\Student\StudentBillController;
use App\Http\Controllers\Student\StudentController;
use App\Http\Controllers\User\UserController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// source route for auth in routes/auth.php
require __DIR__ . '/auth.php';

Route::group(['middleware' => 'auth', 'prefix' => '/dashboard'], function () {
    // Update Password
    Route::patch('/update/password', [PasswordController::class, 'update'])->name('password.update');

    // Management Users
    Route::get('/users', [UserController::class, 'index'])->name('user');
    Route::get('/user/{id}/edit', [UserController::class, 'edit'])->name('user.edit');
    Route::post('/user/create', [UserController::class, 'store'])->name('user.store');
    Route::put('/user/{id}/update', [UserController::class, 'update'])->name('user.update');
    Route::delete('/user/delete', [UserController::class, 'destroy'])->name('user.destroy');

    // Admin
    Route::group(['middleware' => 'isAdmin', 'prefix' => '/admin'], function () {
        Route::get('/', [DashboardController::class, 'index'])->name('admin');

        Route::get('/institution', [InstitutionController::class, 'index'])->name('institut');
        Route::get('/institution/{id}/edit', [InstitutionController::class, 'edit'])->name('admin.institution.edit');

        Route::post('/institution/create', [InstitutionController::class, 'store'])->name('admin.institution.store');
        Route::put('/institution/{id}/update', [InstitutionController::class, 'update'])->name('admin.institution.update');
        Route::delete('/institution/delete', [InstitutionController::class, 'destroy'])->name('admin.institution.destroy');

        Route::get('/config', [ConfigController::class, 'index'])->name('config');
        Route::get('/config/{id}/edit', [ApiTokenController::class, 'edit'])->name('config.api-token.edit');

        Route::post('/config/store', [ConfigController::class, 'store'])->name('config.store');
        Route::post('/config/api_token/store', [ApiTokenController::class, 'store'])->name('config.api-token.store');
        Route::put('/config/api_token/update', [ApiTokenController::class, 'update'])->name('config.api-token.update');
        Route::delete('/config/api_token/delete', [ApiTokenController::class, 'destroy'])->name('config.api-token.destroy');
    });

    // Institution
    Route::group(['middleware' => 'isInstitution', 'prefix' => '/institution'], function () {
        Route::get('/', [DashboardController::class, 'index'])->name('institution');

        // Data Management
        Route::prefix('/data-management')->group(function () {
            // school year
            Route::get('/school-year', [SchoolYearController::class, 'index'])->name('institution.school-year');
            Route::get('/school-year/{id}/edit', [SchoolYearController::class, 'edit'])->name('institution.school-year.edit');

            Route::post('/school-year/create', [SchoolYearController::class, 'store'])->name('institution.school-year.store');
            Route::put('/school-year/{id}/update', [SchoolYearController::class, 'update'])->name('institution.school-year.update');
            Route::delete('/school-year/delete', [SchoolYearController::class, 'destroy'])->name('institution.school-year.destroy');

            // school class
            Route::get('/naik-kelas', [NaikKelasController::class, 'index'])->name('institution.naik-kelas');
            Route::get('/get-kelas', [NaikKelasController::class, 'getKelasByJenjang'])->name('institution.getKelasByJenjang');
            Route::get('/get-students', [NaikKelasController::class, 'getStudents'])->name('institution.getStudents');
            Route::post('/gantiStatus', [NaikKelasController::class, 'gantiStatus'])->name('institution.gantiStatus');

            // Route::get('/class/create', [SchoolClassController::class, 'create'])->name('institution.class.create');
            // Route::get('/class/{id}/edit', [SchoolClassController::class, 'edit'])->name('institution.class.edit');

            // Route::post('/class/create', [SchoolClassController::class, 'store'])->name('institution.class.store');
            // Route::put('/class/{id}/update', [SchoolClassController::class, 'update'])->name('institution.class.update');
            // Route::delete('/class/delete', [SchoolClassController::class, 'destroy'])->name('institution.class.destroy');

            // naik kelas
            Route::get('/class', [SchoolClassController::class, 'index'])->name('institution.class');
            Route::get('/class/create', [SchoolClassController::class, 'create'])->name('institution.class.create');
            Route::get('/class/{id}/edit', [SchoolClassController::class, 'edit'])->name('institution.class.edit');

            Route::post('/class/create', [SchoolClassController::class, 'store'])->name('institution.class.store');
            Route::put('/class/{id}/update', [SchoolClassController::class, 'update'])->name('institution.class.update');
            Route::delete('/class/delete', [SchoolClassController::class, 'destroy'])->name('institution.class.destroy');

            // edulevel
            Route::get('/education-level', [EduLevelController::class, 'index'])->name('institution.edulevel');
            Route::get('/education-level/{id}/edit', [EduLevelController::class, 'edit'])->name('institution.edulevel.edit');

            Route::post('/education-level/create', [EduLevelController::class, 'store'])->name('institution.edulevel.store');
            Route::put('/education-level/{id}/update', [EduLevelController::class, 'update'])->name('institution.edulevel.update');
            Route::delete('/education-level/delete', [EduLevelController::class, 'destroy'])->name('institution.edulevel.destroy');

            // student
            Route::get('/student', [StudentController::class, 'index'])->name('institution.student');
            Route::get('/student/export', [StudentController::class, 'export'])->name('institution.student.export');
            Route::get('/student/export/import-format', [StudentController::class, 'importFormat'])->name('institution.student.importFormat');
            Route::get('/student/{id}/show', [StudentController::class, 'show'])->name('institution.student.show');
            Route::get('/student/{id}/edit', [StudentController::class, 'edit'])->name('institution.student.edit');
            Route::get('/student/{id}/bill/{bill_id}/edit', [StudentBillController::class, 'edit'])->name('institution.student-bill.edit');
            Route::get('/student/{id}/bill/{bill_id}/search', [StudentBillController::class, 'search'])->name('institution.student-bill.search');


            Route::post('/student/create', [StudentController::class, 'store'])->name('institution.student.store');
            Route::post('/student/import/create', [StudentController::class, 'import'])->name('institution.student.import');
            Route::put('/student/{id}/update', [StudentController::class, 'update'])->name('institution.student.update');
            Route::patch('/student/bill/update', [StudentController::class, 'updateBill'])->name('institution.student.bill.update');
            Route::patch('/student/bill/update-with-ajax', [StudentController::class, 'updateBillWithAjax'])->name('institution.student.bill.updateWithAjax');
            Route::patch('/student/bill/update/month', [StudentBillController::class, 'update'])->name('institution.student-bill.update');
            Route::patch('/student/bill/update/actived_at', [StudentBillController::class, 'updateActivedAt'])->name('institution.student-bill.updateActivedAt');
            Route::delete('/student/delete', [StudentController::class, 'destroy'])->name('institution.student.destroy');
            Route::delete('/student/bill/delete', [StudentBillController::class, 'destroy'])->name('institution.student-bill.destroy');
            Route::delete('/student/bill/unpaid', [StudentBillController::class, 'unpaid'])->name('institution.student-bill.unpaid');
        });

        // Report
        Route::prefix('/report')->group(function () {
            Route::get('/finance', [FinanceController::class, 'index'])->name('institution.finance');
            Route::get('/finance/trxDay', [FinanceController::class, 'getTrxDay'])->name('institution.trxDay');
            Route::get('/finance/trxMonth', [FinanceController::class, 'getTrxMonth'])->name('institution.trxMonth');
            Route::get('/finance/trxBill', [FinanceController::class, 'getTrxBill'])->name('institution.trxBill');
            Route::get('/finance/trxBill/export', [FinanceController::class, 'exportBill'])->name('institution.exportBill');
            Route::get('/finance/trxBill/exportMonth', [FinanceController::class, 'exportMonth'])->name('institution.exportMonth');
            Route::get('/finance/trxBill/exportDay', [FinanceController::class, 'exportDay'])->name('institution.exportDay');
            Route::get('/income', [IncomeController::class, 'index'])->name('institution.income');
            Route::get('/settlement', [SettlementController::class, 'index'])->name('institution.settlement');
            Route::post('/settlement/save', [SettlementController::class, 'saveToBIZ'])->name('institution.settlement.save');
            Route::get('/settlement/filter', [SettlementController::class, 'index'])->name('institution.settlement.filter');
            Route::get('/settlement/trxSettlementedu', [SettlementController::class, 'trxSettlementEdu'])->name('institution.settlement.edu');
            // $routes->get('/merchant/settlement/filter', 'Merchant::settlement', ['filter' => 'authMerchant']);

        });

        // Bill
        Route::get('/bill', [BillController::class, 'index'])->name('institution.bill');
        Route::get('/bill/{id}/show', [BillController::class, 'show'])->name('institution.bill.show');
        Route::get('/bill/{id}/edit', [BillController::class, 'edit'])->name('institution.bill.edit');
        Route::get('/bill/{id}/list', [BillDetailController::class, 'index'])->name('institution.bill-detail.index');

        Route::post('/bill/create', [BillController::class, 'store'])->name('institution.bill.store');
        Route::put('/bill/{id}/edit', [BillController::class, 'update'])->name('institution.bill.update');
        Route::delete('/bill/delete', [BillController::class, 'destroy'])->name('institution.bill.destroy');
        Route::delete('/bill/detail/delete', [BillDetailController::class, 'destroy'])->name('institution.bill-detail.destroy');
        Route::post('/bill/detail/create', [BillDetailController::class, 'store'])->name('institution.bill-detail.store');
    });
});
