<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title>Edupay <?php echo e(isset($title) ? ' | ' . $title : ''); ?></title>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('/assets/img/favicon/favicon.png')); ?>" />
    <link rel="manifest" href="<?php echo e(asset('./assets/img/favicon')); ?>/site.webmanifest">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
        href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
        rel="stylesheet" />

    <!-- Icons. Uncomment required icon fonts -->
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>

    <!-- Core CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('./assets/vendor/css/core.css')); ?>" class="template-customizer-core-css" />
    <link rel="stylesheet" href="<?php echo e(asset('./assets/vendor/css/theme-default.css')); ?>"
        class="template-customizer-theme-css" />
    <link rel="stylesheet" href="<?php echo e(asset('./assets/css/demo.css')); ?>" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('./assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css')); ?>" />
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

    <link rel="stylesheet" href="<?php echo e(asset('./assets/vendor/libs/apex-charts/apex-charts.css')); ?>" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    
    
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/spinkit@2.0.1/spinkit.min.css">
    <style>
        :root {
            --bs-body-bg: #F6FFF6 !important;
            --sk-color: grey;
        }

        .bg-footer-theme {
            background-color: var(--bs-body-bg) !important;
        }

        .bg-menu-theme .menu-inner>.menu-item.active>.menu-link {
            color: #129E4B;
            background-color: var(--bs-body-bg) !important;
        }

        .btn-primary {
            background-color: #137a61;
            border-color: #137a61;
            box-shadow: 0 0.125rem 0.25rem 0 rgba(246, 255, 246, 0.4);
        }

        .btn-primary:hover {
            background-color: #00e3bc;
            border-color: #00e3bc;
        }

        .skeleton,
        .skeleton-rounded {
            position: relative;
        }

        .skeleton::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 10;
            background: linear-gradient(90deg, #dadada, #e9e9e9, #e0e0e0);
            background-size: 200%;
            animation: skeleton 1s infinite reverse;
        }

        .skeleton-rounded::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 10;
            background: linear-gradient(90deg, #dadada, #e9e9e9, #e0e0e0);
            background-size: 200%;
            animation: skeleton 1s infinite reverse;
            border-radius: 100%;
        }

        @keyframes  skeleton {
            0% {
                background-position: -100% 0;
            }

            100% {
                background-position: 100% 0;
            }
        }
    </style>
    <?php echo $__env->yieldPushContent('css'); ?>

    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="<?php echo e(asset('./assets/vendor/js/helpers.js')); ?>"></script>

    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="<?php echo e(asset('./assets/js/config.js')); ?>"></script>
</head>

<body>
    <!-- Layout wrapper -->
    <div
        class="layout-wrapper layout-content-navbar layout-menu-fixed <?php if(auth()->user()->role == 'ADMIN'): ?> layout-without-menu <?php endif; ?>">
        
        <div class="layout-container">
            <!-- Menu -->

            <?php echo $__env->make('partials.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->

                <?php echo $__env->make('partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container-xxl flex-grow-1 container-p-y">
                        <?php echo $__env->yieldContent('content'); ?>
                    </div>
                    <!-- / Content -->
                    <!-- Footer -->
                    <?php echo $__env->make('partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <!-- / Footer -->

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->

    <!-- Show Modal -->
    <?php
        $idGantiPass = 'gantiPass';
        $idLoading = 'modal-loading';
        $idSuccess = 'modal-success';
        $idError = 'modal-error';
        $isBackdrop = true;
    ?>
    <!-- change password -->
    <?php if (isset($component)) { $__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\ShowModal::class, ['id' => $idGantiPass]); ?>
<?php $component->withName('show-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
        <div class="modal-header">
            <h5 class="modal-title" id="modalToggleLabel">
                <div id="modalToggleLabel2">Ganti Password</div>
            </h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <form id="formChangePassword" method="POST">
                <?php echo method_field('PATCH'); ?>
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="mb-3 form-password-toggle col-md-12">
                        <div class="d-flex justify-content-between">
                            <label class="form-label" for="old_password">Password Lama</label>
                        </div>
                        <div class="input-group input-group-merge">
                            <input type="password" id="old_password" class="form-control" name="old_password"
                                placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                aria-describedby="old_password" required />
                            <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                            <div class="invalid-feedback"></div>
                        </div>
                    </div>
                    <div class="mb-3 form-password-toggle col-md-6">
                        <div class="d-flex justify-content-between">
                            <label class="form-label" for="password">Password Baru</label>
                        </div>
                        <div class="input-group input-group-merge">
                            <input type="password" id="password" class="form-control" name="password"
                                placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                aria-describedby="password" required />
                            <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                            <div class="invalid-feedback"></div>
                        </div>
                    </div>
                    <div class="mb-3 form-password-toggle col-md-6">
                        <div class="d-flex justify-content-between">
                            <label class="form-label" for="password_confirmation">Verifikasi Password Baru</label>
                        </div>
                        <div class="input-group input-group-merge">
                            <input type="password" id="password_confirmation" class="form-control"
                                name="password_confirmation"
                                placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                aria-describedby="password_confirmation" required />
                            <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                            <div class="invalid-feedback"></div>
                        </div>
                    </div>
                </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                Batal
            </button>
            <input type="submit" name="Simpan" class="btn btn-primary" value="Simpan" id="submit">
        </div>
        </form>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286)): ?>
<?php $component = $__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286; ?>
<?php unset($__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286); ?>
<?php endif; ?>

    <?php echo $__env->yieldPushContent('show-modal'); ?>

    <!-- loading -->
    <?php if (isset($component)) { $__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\ShowModal::class, ['id' => $idLoading,'isBackdrop' => $isBackdrop]); ?>
<?php $component->withName('show-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
        <div class="modal-body">
            <div class="row justify-content-center align-items-center py-5">
                <div class="sk-bounce sk-primary mb-4">
                    <div class="sk-bounce-dot"></div>
                    <div class="sk-bounce-dot"></div>
                </div>
                <h3 class="text-center">Verifying your Data...</h3>
            </div>
        </div>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286)): ?>
<?php $component = $__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286; ?>
<?php unset($__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286); ?>
<?php endif; ?>
    <!-- success -->
    <?php if (isset($component)) { $__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\ShowModal::class, ['id' => $idSuccess]); ?>
<?php $component->withName('show-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
        <div class="modal-body">
            <div class="row justify-content-center align-items-center">
                <img src="<?php echo e(asset('assets/img/illustrations/Confirmed-bro.svg')); ?>" height="170" width="170"
                    style="object-fit: contain;">
                <h3 class="text-center mt-2">Data Berhasil Disimpan!</h3>
                <p class="text-center mt-2 col-md-7">Selamat!, perubahan kamu berhasil disimpan ke database.</p>
            </div>
        </div>
        <div class="modal-footer justify-content-center">
            <button type="button" class="btn btn-primary" data-bs-dismiss="modal">
                Oke
            </button>
        </div>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286)): ?>
<?php $component = $__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286; ?>
<?php unset($__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286); ?>
<?php endif; ?>
    <!-- error -->
    <?php if (isset($component)) { $__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\ShowModal::class, ['id' => $idError]); ?>
<?php $component->withName('show-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
        <div class="modal-body">
            <div class="row justify-content-center align-items-center">
                <img src="<?php echo e(asset('assets/img/illustrations/Software engineer-bro.svg')); ?>" height="170"
                    width="170" style="object-fit: contain;">
                <h3 class="text-center mt-2">Data Gagal Disimpan!</h3>
                <p class="text-center mt-2 col-md-7">Maaf, perubahan kamu gagal disimpan ke database, harap coba lagi.
                </p>
            </div>
        </div>
        <div class="modal-footer justify-content-center">
            <button type="button" class="btn btn-primary" data-bs-dismiss="modal">
                Oke
            </button>
        </div>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286)): ?>
<?php $component = $__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286; ?>
<?php unset($__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286); ?>
<?php endif; ?>


    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="<?php echo e(asset('./assets/vendor/libs/jquery/jquery.js')); ?>"></script>
    <script src="<?php echo e(asset('./assets/vendor/libs/popper/popper.js')); ?>"></script>
    <script src="<?php echo e(asset('./assets/vendor/js/bootstrap.js')); ?>"></script>
    <script src="<?php echo e(asset('./assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js')); ?>"></script>
    <!-- endbuild -->

    <!-- Main JS -->
    <script src="<?php echo e(asset('./assets/vendor/js/menu.js')); ?>"></script>
    <script src="<?php echo e(asset('./assets/js/main.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="https://demos.themeselection.com/sneat-bootstrap-html-admin-template/documentation/assets/js/ui-toasts.js">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    <script>
        window.addEventListener('load', function() {
            AOS.init({
                once: true,
            })
        })
    </script>
    <?php if(session()->has('notif-success')): ?>
        <script>
            Swal.mixin({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.addEventListener('mouseenter', Swal.stopTimer)
                    toast.addEventListener('mouseleave', Swal.resumeTimer)
                }
            }).fire({
                icon: 'success',
                title: "<?php echo e(session('notif-success')); ?>",
            })
        </script>
    <?php endif; ?>
    <?php if(session()->has('notif-error')): ?>
        <script>
            Swal.mixin({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.addEventListener('mouseenter', Swal.stopTimer)
                    toast.addEventListener('mouseleave', Swal.resumeTimer)
                }
            }).fire({
                icon: 'error',
                title: "<?php echo e(session('notif-error')); ?>",
            });
        </script>
    <?php endif; ?>
    <script>
        const allSekeleton = document.querySelectorAll('.skeleton')
        const allSekeletonRounded = document.querySelectorAll('.skeleton-rounded')
        window.addEventListener('load', function() {
            allSekeleton.forEach(item => {
                item.classList.remove('skeleton')
                if (item.classList.contains('skeleton') != true) {
                    $('.menu-item.active').addClass('open')
                }
            })
            allSekeletonRounded.forEach(item => {
                item.classList.remove('skeleton-rounded')
            })
        })
    </script>
    <script>
        $(document).ready(function() {
            $('#password').keyup(function() {
                const oldPass = $('#old_password').val()
                let pass = $(this).val()
                const inputField = $(this)
                if (oldPass === pass) {
                    const errorMessage = 'tidak boleh sama dengan password lama'
                    const feedbackElement = inputField.next(
                        ".invalid-feedback")

                    // Menampilkan pesan error ke dalam elemen "invalid-feedback"
                    feedbackElement.text(errorMessage)
                    $('.invalid-feedback').text(errorMessage)

                    // Menambahkan kelas "is-invalid" pada elemen input yang tidak valid
                    inputField.addClass("is-invalid")
                } else if (pass.length < 6) {
                    const errorMessage = 'tidak boleh kurang dari 6 karakter'
                    const feedbackElement = inputField.next(
                        ".invalid-feedback")

                    // Menampilkan pesan error ke dalam elemen "invalid-feedback"
                    feedbackElement.text(errorMessage)
                    $('.invalid-feedback').text(errorMessage)

                    // Menambahkan kelas "is-invalid" pada elemen input yang tidak valid
                    inputField.addClass("is-invalid")
                } else {
                    if (inputField.hasClass("is-invalid")) {
                        inputField.removeClass("is-invalid")
                    }
                }
            })

            $('#password_confirmation').keyup(function() {
                const pass = $('#password').val()
                let pass_confirm = $(this).val()
                const inputField = $(this)
                if (pass !== pass_confirm) {
                    const errorMessage = 'password tidak sesuai'
                    const feedbackElement = inputField.next(
                        ".invalid-feedback")

                    // Menampilkan pesan error ke dalam elemen "invalid-feedback"
                    feedbackElement.text(errorMessage)
                    $('.invalid-feedback').text(errorMessage)

                    // Menambahkan kelas "is-invalid" pada elemen input yang tidak valid
                    inputField.addClass("is-invalid")
                } else {
                    if (inputField.hasClass("is-invalid")) {
                        inputField.removeClass("is-invalid")
                    }
                }
            })

            $('#formChangePassword').submit(function(e) {
                e.preventDefault();

                // Menambahkan kondisi untuk memeriksa apakah ada elemen dengan class "is-invalid"
                if ($('.is-invalid').length > 0) {
                    // Jika ada, tampilkan pesan bahwa form tidak dapat disubmit karena ada error
                    alert("Form tidak dapat disubmit karena ada error pada input.")
                    return;
                }

                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    type: 'POST',
                    dataType: 'json',
                    data: $(this).serialize(),
                    url: "<?php echo e(route('password.update')); ?>",
                    success: function(response) {
                        console.log(response)
                        $("#formChangePassword :input:not([type='hidden'])").val("")
                        $("#gantiPass").modal('hide')
                        $("#modal-loading").modal('show')

                        setTimeout(function() {
                            $("#modal-loading").modal('hide')
                            $("#modal-success").modal('show')
                        }, 2000);
                    },
                    error: function(xhr, status, error) {
                        if (xhr.status == 422) {
                            const errors = xhr.responseJSON.errors
                            Object.keys(errors).forEach(key => {
                                const errorMessage = errors[key][0]
                                const inputField = $("#" + key)
                                const feedbackElement = inputField.next(
                                    ".invalid-feedback")

                                // Menampilkan pesan error ke dalam elemen "invalid-feedback"
                                feedbackElement.text(errorMessage)
                                $('.invalid-feedback').text(errorMessage)

                                // Menambahkan kelas "is-invalid" pada elemen input yang tidak valid
                                inputField.addClass("is-invalid")
                            });
                        } else {
                            $("#formChangePassword :input:not([type='hidden'])").val("")
                            $("#gantiPass").modal('hide')
                            $("#modal-loading").modal('show')

                            setTimeout(function() {
                                $("#modal-loading").modal('hide')
                                $("#modal-error").modal('show')
                            }, 2000);
                        }
                    }
                })
            })
        })
    </script>
    <script>
        function formatNumber(input) {
            var value = input.value.replace(/\D/g, '');
            var formattedValue = '';
            var separator = '.';
            var count = 0;
            for (var i = value.length - 1; i >= 0; i--) {
                formattedValue = value.charAt(i) + formattedValue;
                count++;
                if (count % 3 === 0 && i !== 0) {
                    formattedValue = separator + formattedValue;
                }
            }

            input.value = formattedValue;
        }

        function numberFormat(number, decimals = 2, decPoint = '.', thousandsSep = ',') {
            number = parseFloat(number).toFixed(decimals);
            var parts = number.toString().split('.');
            parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, thousandsSep);
            return parts.join(decPoint);
        }
    </script>
    <script>
        $(document).ready(function() {
            $('#<?php echo e($idGantiPass); ?>').on('hidden.bs.modal', function() {
                $(this).find('form').trigger('reset');
            })
        })
    </script>
    <?php echo $__env->yieldPushContent('js'); ?>
</body>

</html>
<?php /**PATH /home/bsnc2936/public_html/edupay/resources/views/layouts/dashboard.blade.php ENDPATH**/ ?>