<?php $__env->startSection('title'); ?>
    Santri
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <h4 class="fw-bold py-3 mb-4">
        <span class="text-muted fw-light"><a href="/">Dashboard</a>
            /</span>
        <span class="text-muted fw-light"><a href="<?php echo e(route('institution.student')); ?>">Santri</a>
            /</span>
        <span class="text-muted fw-light"><a href="<?php echo e(route('institution.student.show', $student_id)); ?>">Tagihan
                Santri</a>
            /</span>
        <?php echo e($bill->name); ?>

    </h4>
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-6 mb-2">
                        <div class="form-floating">
                            <input type="text" class="form-control" name="name" id="name" placeholder="Nama"
                                aria-describedby="floatingInputHelp" value="<?php echo e($bill->name); ?>" readonly />
                            <label for="floatingInput">Nama</label>
                        </div>
                    </div>
                    <div class="col-6 mb-2">
                        <div class="form-floating">
                            <input type="text" class="form-control" name="amount" id="amount" placeholder="Total"
                                aria-describedby="floatingInputHelp" value="<?php echo e(number_format($amount, 0, '.', '.')); ?>"
                                readonly />
                            <label for="floatingInput">Total</label>
                        </div>
                    </div>
                    <?php if($bill->bill_category_id == 2): ?>
                        <div class="col mb-2">
                            <form method="POST" id="formActivedAt">
                                <input type="hidden" name="student_id" value="<?php echo e($student_id); ?>">
                                <input type="hidden" name="bill_id" value="<?php echo e($bill_id); ?>">
                                <div class="form-floating">
                                    <input type="date" class="form-control" name="actived_at" id="actived_at"
                                        placeholder="Tanggal Aktif" aria-describedby="floatingInputHelp"
                                        value="<?php echo e($bill_details->first()->actived_at); ?>" />
                                    <label for="floatingInput">Tanggal Aktif</label>
                                </div>
                            </form>
                        </div>
                    <?php endif; ?>
                </div>
                <hr>
                <!-- Daftar Item / Layanan -->
                <h5 class="mt-4">DAFTAR TAGIHAN KESELURUHAN:</h5>
                <div class="table-responsive">
                    <table class="table" style="width: 100%">
                        <thead>
                            <tr>
                                <th>No.</th>
                                <th>Nama Tagihan</th>
                                <th>Jumlah</th>
                                <th>Harga Satuan</th>
                                <th>Subtotal</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $processedAmounts = [];
                                $tableCount = 0;
                            ?>

                            <?php $__currentLoopData = $bill_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(!in_array($details->amount, $processedAmounts)): ?>
                                    <?php
                                        $processedAmounts[] = $details->amount;
                                        $tableCount++;
                                    ?>
                                    <tr>
                                        <td><?php echo e($tableCount); ?></td>
                                        <td><?php echo e($details->bill->name); ?></td>
                                        <td><?php echo e($bill_details->where('amount', $details->amount)->count('*')); ?></td>
                                        <td>Rp <?php echo e(number_format($details->amount, 0, '.', '.')); ?></td>
                                        <td>Rp <?php echo e(number_format($bill_details->where('amount', $details->amount)->sum('amount'), 0, '.', '.')); ?></td>
                                    </tr>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <div class="row justify-content-end p-2">
                    <div class="col-12 gap-2">
                        <?php if($bill_details->count() < 2): ?>
                            <button class="btn btn-primary mt-4" data-bs-toggle="modal" data-bs-target="#modal-confirm">
                                Lunas
                            </button>
                        <?php endif; ?>
                        <?php if($bill->bill_category_id == 2): ?>
                            <button class="btn btn-warning mt-4" id="btnActivedAt">
                                Edit
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <?php if($bill_details->count() > 1): ?>
            <div class="card mt-5">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12 mb-2">
                            <div class="input-group input-group-merge">
                                <span class="input-group-text" id="basic-addon-search31"><i
                                        class="bx bx-search bx-sm"></i></span>
                                <input type="text" id="searchInput" class="form-control form-control-lg"
                                    placeholder="Search..." aria-label="Search..."
                                    aria-describedby="basic-addon-search31" />
                            </div>
                        </div>
                    </div>
                    <hr>
                    <!-- Daftar Item / Layanan -->
                    <h5 class="mt-4">DAFTAR TAGIHAN PERBULAN:</h5>
                    <div class="table-responsive">
                        <form method="POST" id="bill-month">
                            <table class="table" id="month-bill-table">
                                <thead>
                                    <tr>
                                        <th width="2%">
                                            <input type="checkbox" class="dt-checkboxes form-check-input" id="head-cb"
                                                style="height: 16px; width: 16px;" name="ids[]">
                                        </th>
                                        <th>Nominal</th>
                                        <th>Tanggal</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Tambahkan baris lainnya sesuai kebutuhan -->
                                </tbody>
                            </table>
                        </form>
                    </div>
                    <div class="row justify-content-end p-2">
                        <div class="col-12">
                            <button class="btn btn-primary mt-4 item-paid" data-bs-toggle="modal"
                                data-bs-target="#modal-confirms">
                                Lunas
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
    <?php $__env->startPush('show-modal'); ?>
        <?php
            $idConfirm = 'modal-confirm';
            $idConfirms = 'modal-confirms';
        ?>
        <?php if (isset($component)) { $__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\ShowModal::class, ['id' => $idConfirm]); ?>
<?php $component->withName('show-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
            <div class="modal-body">
                <div class="row justify-content-center align-items-center">
                    <img src="<?php echo e(asset('assets/img/illustrations/Shrug-bro.svg')); ?>" height="170" width="170"
                        style="object-fit: contain;">
                    <h3 class="text-center mt-2">Apakah kamu yakin ingin melunasi tagihan ini?</h3>
                </div>
            </div>
            <div class="modal-footer justify-content-center">
                <form action="<?php echo e(route('institution.student.bill.update')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PATCH'); ?>
                    <input type="hidden" name="student_id" value="<?php echo e($student_id); ?>">
                    <input type="hidden" name="bill_id" value="<?php echo e($bill_id); ?>">
                    <button type="submit" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                        Oke
                    </button>
                </form>
                <button type="button" class="btn btn-primary" data-bs-dismiss="modal">
                    Cancel
                </button>
            </div>
         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286)): ?>
<?php $component = $__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286; ?>
<?php unset($__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286); ?>
<?php endif; ?>
        <?php if (isset($component)) { $__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\ShowModal::class, ['id' => $idConfirms]); ?>
<?php $component->withName('show-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
            <div class="modal-body">
                <div class="row justify-content-center align-items-center">
                    <img src="<?php echo e(asset('assets/img/illustrations/Shrug-bro.svg')); ?>" height="170" width="170"
                        style="object-fit: contain;">
                    <h3 class="text-center mt-2">Apakah kamu yakin ingin melunasi tagihan ini?</h3>
                </div>
            </div>
            <div class="modal-footer justify-content-center">
                <input type="hidden" name="id-confirm">
                <button type="submit" class="btn btn-outline-secondary" data-bs-dismiss="modal" id="btn-paid">
                    Oke
                </button>
                <button type="button" class="btn btn-primary" data-bs-dismiss="modal">
                    Cancel
                </button>
            </div>
         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286)): ?>
<?php $component = $__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286; ?>
<?php unset($__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286); ?>
<?php endif; ?>
    <?php $__env->stopPush(); ?>
    <?php $__env->startPush('css'); ?>
    <style>
        .table-responsive {
            overflow-x: auto;
        }
        
        .table th,
        .table td {
            white-space: nowrap;
        }

        .table th:first-child,
        .table td:first-child { min-width: 50px; }    /* No. */
        .table th:nth-child(2),
        .table td:nth-child(2) { min-width: 200px; }  /* Nama Tagihan */
        .table th:nth-child(3),
        .table td:nth-child(3) { min-width: 100px; }  /* Jumlah */
        .table th:nth-child(4),
        .table td:nth-child(4) { min-width: 150px; }  /* Harga Satuan */
        .table th:nth-child(5),
        .table td:nth-child(5) { min-width: 150px; }  /* Subtotal */
    </style>
    <?php $__env->stopPush(); ?>
    <?php $__env->startPush('css'); ?>
    <style>
        #month-bill-table {
            width: 100% !important;
        }
        
        #month-bill-table th,
        #month-bill-table td {
            white-space: nowrap;
        }

        #month-bill-table th:first-child,
        #month-bill-table td:first-child { min-width: 40px; }  /* Checkbox */
        #month-bill-table th:nth-child(2),
        #month-bill-table td:nth-child(2) { min-width: 150px; } /* Nominal */
        #month-bill-table th:nth-child(3),
        #month-bill-table td:nth-child(3) { min-width: 120px; } /* Tanggal */
        #month-bill-table th:last-child,
        #month-bill-table td:last-child { min-width: 50px; }   /* Status Icon */
    </style>
    <?php $__env->stopPush(); ?>
    <?php $__env->startPush('js'); ?>
        <!-- include jQuery -->
        <script src="http://ajax.googleapis.com/ajax/libs/jquery/1/jquery.js"></script>
        <!-- include BlockUI -->
        <script src="https://cdn.jsdelivr.net/npm/jquery-blockui@2.7.0/jquery.blockUI.min.js"></script>
        <script>
            $('#head-cb').on('click', function() {
                $('.child-cb').prop('checked', this.checked)
            })
        </script>
        <script>
            function createBillMonthTable() {
                $.ajax({
                    url: "<?php echo e(route('institution.student-bill.search', [$student_id, $bill_id])); ?>",
                    type: "GET",
                    success: function(data) {
                        // Hapus isi tabel
                        $('#month-bill-table tbody').empty();

                        // Isi tabel dengan hasil pencarian
                        $.each(data, function(index, result) {
                            $('#month-bill-table tbody').append(`
                            <tr>
                                <td>
                                    <input type="checkbox" class="dt-checkboxes form-check-input ${result.status !== 'PAID' ? 'child-cb' : ''}"
                                        style="height: 16px; width: 16px;" name="ids[]" value="${result.id}" ${result.status === 'PAID' ? 'disabled' : ''}>
                                </td>
                                <td>
                                    Rp ${numberFormat(result.amount, 0, '.', '.')}
                                </td>
                                <td>
                                    ${result.actived_at}
                                </td>
                                <td>
                                    ${result.status === 'PAID' ? '<i class="bx bxs-check-circle bx-md text-primary"></i>' : ''}
                                </td>
                            </tr>
                        `);
                        });
                    },
                    error: function() {
                        // Handle error
                    }
                })
            }
            $(document).ready(function() {
                createBillMonthTable()

                $('#btnActivedAt').on('click', function() {
                    const inputActivedAt = $('#actived_at');
                    const serializedActivedAt = $('#formActivedAt').serialize();

                    console.log(inputActivedAt.val());
                    // ajax
                    $.ajax({
                        url: "<?php echo e(route('institution.student-bill.updateActivedAt')); ?>",
                        type: "PATCH",
                        data: serializedActivedAt,
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        beforeSend: function() {
                            $('html').block({
                                message: '<div class="spinner-border text-primary" role="status"></div>',
                                timeout: 0,
                                css: {
                                    backgroundColor: "transparent",
                                    border: "0"
                                },
                                overlayCSS: {
                                    backgroundColor: "#000",
                                    opacity: 0.25
                                }
                            })
                        },
                        success: function(response) {
                            console.log(response);

                            // location.reload();
                            Swal.fire({
                                icon: !response.success ? 'error' : 'success',
                                title: response.description,
                                didClose: (result) => {
                                    location.reload()
                                }
                            })
                        },
                        error: function(xhr, status, error) {
                            // Mendapatkan pesan error dari respons JSON
                            const errors = xhr.responseJSON.errors;
                            console.log(errors)
                            console.log(status)
                            console.log(error)
                        },
                        complete: function() {
                            // This function will run when the request (success or error) is complete
                            // You can unblock the page here
                            $('html').unblock();
                        }
                    });
                });

                $('.item-paid').on('click', function() {
                    let data = $(this).data('delete')
                    if (!$('input[name="ids[]"]:checked').length > 0) {
                        $('input[name="id-confirm"]').val(data)
                    }
                })


                $('#searchInput').on('keyup', function() {
                    const searchTerm = $(this).val();
                    $.ajax({
                        url: "<?php echo e(route('institution.student-bill.search', [$student_id, $bill_id])); ?>",
                        type: "GET",
                        data: {
                            searchTerm: searchTerm
                        },
                        success: function(data) {
                            console.log(data)
                            // Hapus isi tabel
                            $('#month-bill-table tbody').empty();

                            // Isi tabel dengan hasil pencarian
                            $.each(data, function(index, result) {
                                $('#month-bill-table tbody').append(`
                            <tr>
                                <td>
                                    <input type="checkbox" class="dt-checkboxes form-check-input child-cb"
                                        style="height: 16px; width: 16px;" name="ids[]" value="${result.id}">
                                </td>
                                <td>
                                    Rp ${numberFormat(result.amount, 0, '.', '.')}
                                </td>
                                <td>
                                    ${result.actived_at}
                                </td>
                                <td>
                                    ${result.status === 'PAID' ? '<i class="bx bxs-check-circle bx-md text-primary"></i>' : ''}
                                </td>
                            </tr>
                        `);
                            });
                        },
                        error: function() {
                            // Handle error
                        }
                    })
                })

                $('#btn-paid').on('click', function() {
                    var serializedData = $('#bill-month').serialize();
                    var idConfirmValue = encodeURIComponent($('input[name="id-confirm"]').val());
                    $.ajax({
                        url: "<?php echo e(route('institution.student-bill.update')); ?>",
                        type: 'PATCH',
                        data: serializedData,
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        beforeSend: function() {
                            $('html').block({
                                message: '<div class="spinner-border text-primary" role="status"></div>',
                                timeout: 0,
                                css: {
                                    backgroundColor: "transparent",
                                    border: "0"
                                },
                                overlayCSS: {
                                    backgroundColor: "#000",
                                    opacity: 0.25
                                }
                            })
                        },
                        success: function(response) {
                            console.log(response)
                            createBillMonthTable()
                            // location.reload();
                            Swal.fire({
                                icon: !response.success ? 'error' : 'success',
                                title: !response.success ? response.error : response
                                    .description,
                                didClose: (result) => {
                                    location.reload()
                                }
                            })
                        },
                        error: function(xhr, status, error) {
                            // Mendapatkan pesan error dari respons JSON
                            const errors = xhr.responseJSON.errors;
                            console.log(errors)
                        },
                        complete: function() {
                            // This function will run when the request (success or error) is complete
                            // You can unblock the page here
                            $('html').unblock();
                        }
                    })
                })
            })
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u1571340/public_html/edupay/edupay/resources/views/pages/institution/manage-data/student/edit-bill.blade.php ENDPATH**/ ?>