

<?php $__env->startSection('title'); ?>
Dashboard
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
<div class="row">
    <h4 class="fw-bold py-3 mb-4">
        
        <span class="">
            Dashboard
        </span>
    </h4>

    <!-- card day profit -->
    <?php echo $__env->make('partials.dashboard.card-profit', [
    'title' => 'Pendapatan Hari Ini',
    'result' => number_format($paymentsPerDay[date('Y-m-d')] ?? 0, 0, ',', '.') . ',-',
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <!-- card month profit -->
    <?php echo $__env->make('partials.dashboard.card-profit', [
    'title' => 'Pendapatan Bulan Ini',
    'result' => number_format($paymentsPerMonth[date('Y-m')] ?? 0, 0, ',', '.') . ',-',
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="py-3">
        <div class="card">
            <div class="card-body">
                <!-- Fold -->
                
                <div id="chart" data-aos="zoom-out" data-aos-duration="500" class="mb-2"></div>
            </div>
        </div>
    </div>

</div>

<?php $__env->startPush('js'); ?>
<!-- Vendors JS -->

<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
<!-- Page JS -->
<script src="<?php echo e(asset('./assets/js/dashboards-analytics.js')); ?>"></script>

<script src="<?php echo e(mix('js/app.js')); ?>"></script>

<script>
    const loading = document.querySelector('#loading')

            window.addEventListener('load', function() {
                loading.classList.add('d-none')
            })
</script>

<script>
    var paymentsToday = <?php echo json_encode($paymentsToday); ?>;

            var endDate = new Date();
            var startDate = new Date();
            startDate.setDate(endDate.getDate() - 6);

            var dateArray = [];
            var currentDate = startDate;
            while (currentDate <= endDate) {
                dateArray.push(new Date(currentDate));
                currentDate.setDate(currentDate.getDate() + 1);
            }

            var formattedDates = dateArray.map(function(date) {
                return date.toLocaleDateString('en-US', {
                    day: '2-digit',
                    month: '2-digit'
                });
            });

            var seriesData = dateArray.map(function(date) {
                var dateKey = date.toISOString().slice(0, 10);
                var total = paymentsToday[dateKey] || 0;

                return {
                    x: date.getTime(),
                    y: total
                };
            });
            var uniqueDates = Array.from(new Set(formattedDates));
            var options = {
                chart: {
                    height: 380,
                    width: "100%",
                    type: "area",
                    animations: {
                        initialAnimation: {
                            enabled: false
                        }
                    }
                },
                series: [{
                    name: "Transaksi",
                    data: seriesData
                }],
                fill: {
                    type: "gradient",
                    gradient: {
                        shadeIntensity: 1,
                        opacityFrom: 0.7,
                        opacityTo: 0.9,
                        stops: [0, 90, 100]
                    }
                },
                yaxis: {
                    title: {
                        text: 'Total Transaksi'
                    },
                    labels: {
                        formatter: function(value) {
                            return Math.round(value);
                        }
                    }
                },
                xaxis: {
                    type: "datetime",
                    categories: uniqueDates,
                    labels: {
                        format: "dd MMM"
                    }
                }
            };
            var chart = new ApexCharts(document.querySelector("#chart"), options);

            chart.render();
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u1571340/public_html/edupay/edupay/resources/views/pages/institution/index.blade.php ENDPATH**/ ?>